package cc.thonly.reverie_dreams.registry.content;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.data.FumoType;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import java.util.Collection;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class FumoTypes {
    public static final RegistryHandler<FumoType> REGISTRY_KEY = RegistryHandlers.FUMO;
    public static final FumoType ALICE = register(new FumoType(ReverieDreams.id("alice"), new class_243(0, 0, 0)));
    public static final FumoType AYA = register(new FumoType(ReverieDreams.id("aya"), new class_243(0, 0, 0)));
    public static final FumoType BLUE_REIMU = register(new FumoType(ReverieDreams.id("blue_reimu"), new class_243(0, 0, 0)));
    public static final FumoType CHEN = register(new FumoType(ReverieDreams.id("chen"), new class_243(0, 0, 0)));
    public static final FumoType CHERRIES_SHION = register(new FumoType(ReverieDreams.id("cherries_shion"), new class_243(0, 0, 0)));
    public static final FumoType CHIMATA = register(new FumoType(ReverieDreams.id("chimata"), new class_243(0, 0, 0)));
    public static final FumoType CIRNO = register(new FumoType(ReverieDreams.id("cirno"), new class_243(0, 0, 0)));
    public static final FumoType CLOWNPIECE = register(new FumoType(ReverieDreams.id("clownpiece"), new class_243(0, 0, 0)));
    public static final FumoType EIKI = register(new FumoType(ReverieDreams.id("eiki"), new class_243(0, -0.26, 0)));
    public static final FumoType EIRIN = register(new FumoType(ReverieDreams.id("eirin"), new class_243(0, -0.26, 0)));
    public static final FumoType FLAN = register(new FumoType(ReverieDreams.id("flan"), new class_243(0, 0, 0)));
    public static final FumoType FLANDRE = register(new FumoType(ReverieDreams.id("flandre"), new class_243(0, -0.26, 0)));
    public static final FumoType HATATE = register(new FumoType(ReverieDreams.id("hatate"), new class_243(0, 0, 0)));
    public static final FumoType JOON = register(new FumoType(ReverieDreams.id("joon"), new class_243(0, -0.26, 0)));
    public static final FumoType KAGUYA = register(new FumoType(ReverieDreams.id("kaguya"), new class_243(0, 0, 0)));
    public static final FumoType KANMARISA = register(new FumoType(ReverieDreams.id("kanmarisa"), new class_243(0, 0, 0)));
    public static final FumoType KASEN = register(new FumoType(ReverieDreams.id("kasen"), new class_243(0, -0.26, 0)));
    public static final FumoType KOGASA = register(new FumoType(ReverieDreams.id("kogasa"), new class_243(0, -0.26, 0)));
    public static final FumoType KOISHI = register(new FumoType(ReverieDreams.id("koishi"), new class_243(0, 0, 0)));
    public static final FumoType KOKORO = register(new FumoType(ReverieDreams.id("kokoro"), new class_243(0, 0, 0)));
    public static final FumoType KOSUZU = register(new FumoType(ReverieDreams.id("kosuzu"), new class_243(0, -0.26, 0)));
    public static final FumoType MARISA = register(new FumoType(ReverieDreams.id("marisa"), new class_243(0, 0, 0)));
    public static final FumoType MARISA_HAT = register(new FumoType(ReverieDreams.id("marisa_hat"), new class_243(0, 0, 0)));
    public static final FumoType MCKY = register(new FumoType(ReverieDreams.id("mcky"), new class_243(0, 0, 0)));
    public static final FumoType MEILING = register(new FumoType(ReverieDreams.id("meiling"), new class_243(0, -0.26, 0)));
    public static final FumoType MELON = register(new FumoType(ReverieDreams.id("melon"), new class_243(0, 0, 0)));
    public static final FumoType MOKOU = register(new FumoType(ReverieDreams.id("mokou"), new class_243(0, 0, 0)));
    public static final FumoType MOMIJI = register(new FumoType(ReverieDreams.id("momiji"), new class_243(0, 0, 0)));
    public static final FumoType MYSTIA = register(new FumoType(ReverieDreams.id("mystia"), new class_243(0, 0, 0)));
    public static final FumoType NAZRIN = register(new FumoType(ReverieDreams.id("nazrin"), new class_243(0, 0, 0)));
    public static final FumoType NEW_REIMU = register(new FumoType(ReverieDreams.id("new_reimu"), new class_243(0, 0, 0)));
    public static final FumoType NUE = register(new FumoType(ReverieDreams.id("nue"), new class_243(0, 0, 0)));
    public static final FumoType PARSEE = register(new FumoType(ReverieDreams.id("parsee"), new class_243(0, 0, 0)));
    public static final FumoType PATCHOULI = register(new FumoType(ReverieDreams.id("patchouli"), new class_243(0, 0, 0)));
    public static final FumoType PC98_MARISA = register(new FumoType(ReverieDreams.id("pc98_marisa"), new class_243(0, 0, 0)));
    public static final FumoType RAN = register(new FumoType(ReverieDreams.id("ran"), new class_243(0, 0, 0)));
    public static final FumoType REIMU = register(new FumoType(ReverieDreams.id("reimu"), new class_243(0, 0, 0)));
    public static final FumoType REISEN = register(new FumoType(ReverieDreams.id("reisen"), new class_243(0, 0, 0)));
    public static final FumoType REMILIA = register(new FumoType(ReverieDreams.id("remilia"), new class_243(0, 0, 0)));
    public static final FumoType RENKO = register(new FumoType(ReverieDreams.id("renko"), new class_243(0, 0, 0)));
    public static final FumoType RUMIA = register(new FumoType(ReverieDreams.id("rumia"), new class_243(0, 0, 0)));
    public static final FumoType SAKUYA = register(new FumoType(ReverieDreams.id("sakuya"), new class_243(0, 0, 0)));
    public static final FumoType SANAE = register(new FumoType(ReverieDreams.id("sanae"), new class_243(0, 0, 0)));
    public static final FumoType SATORI = register(new FumoType(ReverieDreams.id("satori"), new class_243(0, 0, 0)));
    public static final FumoType SEIJA = register(new FumoType(ReverieDreams.id("seija"), new class_243(0, 0, 0)));
    public static final FumoType SHION = register(new FumoType(ReverieDreams.id("shion"), new class_243(0, 0, 0)));
    public static final FumoType SHOU = register(new FumoType(ReverieDreams.id("shou"), new class_243(0, 0, 0)));
    public static final FumoType SMART_CIRNO = register(new FumoType(ReverieDreams.id("smart_cirno"), new class_243(0, 0, 0)));
    public static final FumoType SUIKA = register(new FumoType(ReverieDreams.id("suika"), new class_243(0, 0, 0)));
    public static final FumoType SUWAKO = register(new FumoType(ReverieDreams.id("suwako"), new class_243(0, 0, 0)));
    public static final FumoType TAN_CIRNO = register(new FumoType(ReverieDreams.id("tan_cirno"), new class_243(0, 0, 0)));
    public static final FumoType TENSHI = register(new FumoType(ReverieDreams.id("tenshi"), new class_243(0, 0, 0)));
    public static final FumoType TEWI = register(new FumoType(ReverieDreams.id("tewi"), new class_243(0, 0, 0)));
    public static final FumoType UTSUHO = register(new FumoType(ReverieDreams.id("utsuho"), new class_243(0, 0, 0)));
    public static final FumoType WAKASAGIHIME = register(new FumoType(ReverieDreams.id("wakasagihime"), new class_243(0, 0, 0)));
    public static final FumoType YOUMU = register(new FumoType(ReverieDreams.id("youmu"), new class_243(0, 0, 0)));
    public static final FumoType YUKARI = register(new FumoType(ReverieDreams.id("yukari"), new class_243(0, 0, 0)));
    public static final FumoType YUUKA = register(new FumoType(ReverieDreams.id("yuuka"), new class_243(0, 0, 0)));
    public static final FumoType YUYUKO = register(new FumoType(ReverieDreams.id("yuyuko"), new class_243(0, 0, 0)));

    public static FumoType register(FumoType fumo) {
        return register(fumo.getId(), fumo);
    }

    public static FumoType register(String name, FumoType fumo) {
        return register(ReverieDreams.id(name), fumo);
    }

    public static FumoType register(class_2960 id, FumoType fumo) {
        return RegistryHandlers.register(REGISTRY_KEY, id, fumo.build());
    }

    public static Collection<FumoType> getView() {
        return REGISTRY_KEY.values();
    }

    public static void bootstrap(RegistryHandler<FumoType> registry) {

    }
}
