package cc.thonly.reverie_dreams.registry.content;

import cc.thonly.reverie_dreams.registry.PairRegistryHandlers;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public record ItemColor(class_1792 item, Long color) {
    public static final ItemColor WHITE = registerItemColor(class_1802.field_8446, 16777215L);
    public static final ItemColor ORANGE = registerItemColor(class_1802.field_8492, 16749605L);
    public static final ItemColor MAGENTA = registerItemColor(class_1802.field_8669, 15082670L);
    public static final ItemColor LIGHT_BLUE = registerItemColor(class_1802.field_8273, 2067967L);
    public static final ItemColor YELLOW = registerItemColor(class_1802.field_8192, 16776998L);
    public static final ItemColor LIME = registerItemColor(class_1802.field_8131, 14352166L);
    public static final ItemColor PINK = registerItemColor(class_1802.field_8330, 16724365L);
    public static final ItemColor GRAY = registerItemColor(class_1802.field_8298, 10197915L);
    public static final ItemColor LIGHT_GRAY = registerItemColor(class_1802.field_8851, 7434609L);
    public static final ItemColor CYAN = registerItemColor(class_1802.field_8632, 1099519L);
    public static final ItemColor PURPLE = registerItemColor(class_1802.field_8296, 16721620L);
    public static final ItemColor BLUE = registerItemColor(class_1802.field_8345, 526591L);
    public static final ItemColor BROWN = registerItemColor(class_1802.field_8099, 10495744L);
    public static final ItemColor GREEN = registerItemColor(class_1802.field_8408, 3473204L);
    public static final ItemColor RED = registerItemColor(class_1802.field_8264, 16724273L);
    public static final ItemColor BLACK = registerItemColor(class_1802.field_8226, 2500134L);

    public class_1799 color(class_1792 item) {
        class_1799 itemStack = item.method_7854();
        return this.color(itemStack);
    }

    public class_1799 color(class_1799 itemStack) {
        itemStack.method_57379(class_9334.field_49644, new class_9282(this.color().intValue()));
        return itemStack;
    }

    public static ItemColor registerItemColor(class_1792 item, Long value) {
        return PairRegistryHandlers.register(PairRegistryHandlers.ITEM_COLOR, item, new ItemColor(item, value));
    }

    public static Map<class_1792, Long> getView() {
        Map<class_1792, Long> view = new LinkedHashMap<>();
        PairRegistryHandlers.ITEM_COLOR.keysStream().forEach(item -> {
            ItemColor color = PairRegistryHandlers.ITEM_COLOR.get(item);
            if (color != null) {
                view.put(item, color.color());
            }
        });
        return view;
    }
}
