package cc.thonly.reverie_dreams.registry.content.component;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.component.BattleStickRecorder;
import cc.thonly.reverie_dreams.component.DanmakuProperties;
import cc.thonly.reverie_dreams.component.GapRecorder;
import cc.thonly.reverie_dreams.component.RoleFollowerArchive;
import cc.thonly.reverie_dreams.component.tooltip.TooltipManager;
import cc.thonly.reverie_dreams.data.danmaku.SpellcardRenderer;
import cc.thonly.reverie_dreams.data.danmaku.spellcard.SpellCardFrameConfig;
import cc.thonly.reverie_dreams.item.prop.MusicalInstrumentItem;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import com.mojang.serialization.Codec;
import eu.pb4.polymer.core.api.other.PolymerComponent;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_2378;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import java.util.List;

@Slf4j
public class RDDataComponents {
    public static final class_9331<DanmakuProperties> DANMAKU_PROPERTIES = registerComponent("danmaku_properties",
            class_9331.<DanmakuProperties>method_57873()
                    .method_57881(DanmakuProperties.CODEC)
                    .method_57880()
    );
    public static final class_9331<SpellCardFrameConfig> SPELLCARD_FRAME_CONFIG = registerComponent("spellcard_frame",
            class_9331.<SpellCardFrameConfig>method_57873()
                    .method_57881(SpellCardFrameConfig.CODEC)
                    .method_57880());
    public static final class_9331<SpellcardRenderer> SPELL_CARD_COMPONENT = registerComponent("spell_card_component",
            class_9331.<SpellcardRenderer>method_57873()
                    .method_57881(SpellcardRenderer.CODEC)
                    .method_57880());
    public static final class_9331<ItemStackWrapper> DANMAKU_SHAPE = registerComponent("shape",
            class_9331.<ItemStackWrapper>method_57873()
                    .method_57881(ItemStackWrapper.CODEC)
                    .method_57880());
    public static final class_9331<Integer> FOV = registerComponent("fov",
            class_9331.<Integer>method_57873()
                    .method_57881(Codec.INT)
                    .method_57880());
    public static final class_9331<class_3902> SILVER_ITEM = registerComponent("silver_item",
            class_9331.<class_3902>method_57873()
                    .method_57881(class_3902.field_51563)
                    .method_57880()
    );
    public static final class_9331<class_2960> ROLE_CARD_ID = registerComponent("role_card_id",
            class_9331.<class_2960>method_57873()
                    .method_57881(class_2960.field_25139)
                    .method_57880());
    public static final class_9331<Integer> MAX_DISTANCE = registerComponent("max_distance",
            class_9331.<Integer>method_57873()
                    .method_57881(Codec.INT)
                    .method_57880());
    public static final class_9331<List<GapRecorder>> GAP_RECORDER = registerComponent("gap_recorder",
            class_9331.<List<GapRecorder>>method_57873()
                    .method_57881(GapRecorder.LIST_CODEC)
                    .method_57880());
    public static final class_9331<BattleStickRecorder> BATTLE_STICK_RECORDER = registerComponent("battle_stick_recorder",
            class_9331.<BattleStickRecorder>method_57873()
                    .method_57881(BattleStickRecorder.CODEC)
                    .method_57880());
    public static final class_9331<String> PLAYING_MUSIC = registerComponent("playing_music",
            class_9331.<String>method_57873()
                    .method_57881(Codec.STRING)
                    .method_57880());
    public static final class_9331<class_2766> NOTE_TYPE = registerComponent("note_type",
            class_9331.<class_2766>method_57873()
                    .method_57881(MusicalInstrumentItem.NOTE_BLOCK_INSTRUMENT_CODEC)
                    .method_57880());
    public static final class_9331<RoleFollowerArchive> ROLE_FOLLOWER_ARCHIVE = registerComponent("role_follower_archive",
            class_9331.<RoleFollowerArchive>method_57873()
                    .method_57881(RoleFollowerArchive.CODEC)
                    .method_57880()
    );
    public static final class_9331<Boolean> ROLE_CAN_RESPAWN = registerComponent("role_can_respawn",
            class_9331.<Boolean>method_57873()
                    .method_57881(Codec.BOOL)
                    .method_57880()
    );
    public static final class_9331<List<String>> FOOD_PROPERTIES = registerComponent("food_properties",
            class_9331.<List<String>>method_57873()
                    .method_57881(Codec.list(Codec.STRING))
                    .method_57880()
    );
    public static final class_9331<List<String>> DRINK_PROPERTIES = registerComponent("drink_properties",
            class_9331.<List<String>>method_57873()
                    .method_57881(Codec.list(Codec.STRING))
                    .method_57880()
    );
    public static final class_9331<Integer> FOOD_BONUS = registerComponent("food_bonus",
            class_9331.<Integer>method_57873().method_57881(Codec.INT).method_57880()
    );

    public static void init() {
        TooltipManager.bootstrap();
    }

    public static <T> class_9331<T> registerComponent(String path, class_9331<T> componentType) {
        class_9331<T> value = class_2378.method_10230(class_7923.field_49658, ReverieDreams.id(path), componentType);
        PolymerComponent.registerDataComponent(value);
        return value;
    }
}
