package cc.thonly.reverie_dreams.registry.content.danmaku;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.data.danmaku.DanmakuType;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.content.ItemColor;
import cc.thonly.reverie_dreams.registry.content.RDDamageTypes;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_8110;

public class DanmakuTypes {
    public static final DanmakuType AMULET = registerType(ReverieDreams.id("amulet"), RDDamageTypes.DANMAKU_GENERIC, 2f, 1f, 0.75f, false, false);
    public static final DanmakuType ARROWHEAD = registerType(ReverieDreams.id("arrowhead"), RDDamageTypes.DANMAKU_REAL, 2f, 1f, 0.75f, false, false);
    public static final DanmakuType BALL = registerType(ReverieDreams.id("ball"), RDDamageTypes.DANMAKU_GENERIC, 2f, 1f, 0.75f, true, false);
    public static final DanmakuType BUBBLE = registerType(ReverieDreams.id("bubble"), RDDamageTypes.DANMAKU_GENERIC, 2.5f, 2f, 0.75f, true, false);
    public static final DanmakuType BULLET = registerType(ReverieDreams.id("bullet"), RDDamageTypes.DANMAKU_REAL, 3f, 1f, 0.75f, false, false);
    public static final DanmakuType FIREBALL = registerType(ReverieDreams.id("fireball"), RDDamageTypes.DANMAKU_GENERIC, 2f, 1f, 0.75f, true, false);
    public static final DanmakuType FIREBALL_GLOWY = registerType(ReverieDreams.id("fireball_glowy"), RDDamageTypes.DANMAKU_GENERIC, 1f, 1f, 0.75f, true, false);
    public static final DanmakuType KUNAI = registerType(ReverieDreams.id("kunai"), RDDamageTypes.DANMAKU_REAL, 2f, 1f, 0.75f, false, false);
    public static final DanmakuType RICE = registerType(ReverieDreams.id("rice"), RDDamageTypes.DANMAKU_GENERIC, 2f, 1f, 0.75f, false, false);
    public static final DanmakuType STAR = registerType(ReverieDreams.id("star"), RDDamageTypes.DANMAKU_GENERIC, 2f, 1f, 0.75f, true, false);
    public static final DanmakuType NOTE = registerType(ReverieDreams.id("note"), RDDamageTypes.DANMAKU_GENERIC, 2f, 1f, 1.2f, false, false);
    public static final DanmakuType LASER = registerType(ReverieDreams.id("laser"), RDDamageTypes.DANMAKU_GENERIC, 4f, 1.5f, 0.75f, false, false).unlist();
    public static final DanmakuType BIG_LASER = registerType(ReverieDreams.id("big_laser"), RDDamageTypes.DANMAKU_GENERIC, 4f, 1.5f, 0.75f, false, false).unlist();

    public static DanmakuType registerType(class_2960 key, class_5321<class_8110> damageTypeKey, float damage, float scale, float speed, boolean tile, boolean infinite) {
        return RegistryHandlers.registerForBuiltin(RegistryHandlers.DANMAKU_TYPE, key, new DanmakuType(key, damageTypeKey, damage, scale, speed, tile, infinite));
    }

    @SuppressWarnings("DataFlowIssue")
    public static class_1799 withColor(DanmakuType type, ItemColor color) {
        List<class_3545<class_1792, class_1799>> colorPair = type.getColorPairs();
        class_3545<class_1792, class_1799> result = new class_3545<>(null, null);
        for (class_3545<class_1792, class_1799> pair : colorPair) {
            if (pair.method_15442() == color.item()) {
                result = pair;
                break;
            }
        }
        return result.method_15441();
    }

    public static class_1799 random() {
        List<DanmakuType> values = RegistryHandlers.DANMAKU_TYPE.values().stream().toList();
        DanmakuType type = values.get(new Random().nextInt(values.size()));
        return random(type);
    }

    public static class_1799 random(DanmakuType type) {
        List<class_3545<class_1792, class_1799>> colorPair = type.getColorPairs();
        class_3545<class_1792, class_1799> pair = colorPair.get(new Random().nextInt(colorPair.size()));
        return pair.method_15441().method_7972();
    }

    public static List<class_1799> allColor() {
        ImmutableList.Builder<class_1799> builder = ImmutableList.builder();
        List<DanmakuType> typeList = RegistryHandlers.DANMAKU_TYPE.values().stream().filter(type -> !type.isDeleteFromList()).toList();
        for (DanmakuType danmakuType : typeList) {
            List<class_3545<class_1792, class_1799>> colorPair = danmakuType.getColorPairs();
            for (class_3545<class_1792, class_1799> pair : colorPair) {
                builder.add(pair.method_15441());
            }
        }
        return builder.build();
    }

    public static void bootstrap(RegistryHandler<DanmakuType> registry) {

    }

}
