package cc.thonly.reverie_dreams.registry.content.entity;

import cc.thonly.registry_modifier.api.DynamicRegistryManagerCallback;
import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.entity.*;
import cc.thonly.reverie_dreams.entity.elemental.FireElementalEntity;
import cc.thonly.reverie_dreams.entity.elemental.IceElementalEntity;
import cc.thonly.reverie_dreams.entity.elemental.WaterElementalEntity;
import cc.thonly.reverie_dreams.entity.misc.*;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.entity.npc.NPCRoleEntity;
import cc.thonly.reverie_dreams.entity.villager.FumoSellerVillager;
import cc.thonly.reverie_dreams.entity.villager.TavernVillager;
import cc.thonly.reverie_dreams.item.base.SpawnEggItem;
import cc.thonly.reverie_dreams.registry.content.skin.MobSkinTypes;
import cc.thonly.reverie_dreams.util.IdentifierGetter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.minecraft.class_10586;
import net.minecraft.class_10693;
import net.minecraft.class_10702;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1429;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.world.entity.*;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SuppressWarnings({"unchecked", "DataFlowIssue"})
public class RDEntityTypes {
    public static final Map<class_1299<?>, class_1792> SPAWN_EGG_BIND = new Object2ObjectOpenHashMap<>(128);
    public static final List<class_1792> SPAWN_EGG_ITEM_LIST = new ArrayList<>(128);
    public static final List<class_1299<?>> ENTITY_TYPES = new ArrayList<>(128);

    public static class_1792 registerSpawnEggItem(IdentifierGetter item) {
        class_2378.method_10230(class_7923.field_41178, item.getIdentifier(), (class_1792) item);
        SPAWN_EGG_ITEM_LIST.add((class_1792) item);
        return (class_1792) item;
    }

    public static List<class_1792> getSpawnEggItemView() {
        return List.copyOf(SPAWN_EGG_ITEM_LIST);
    }

    public static final class_1299<NPCRoleEntity> NPC_ROLE =
            registerEntity("base_character",
                    class_1299.class_1300.method_5903(NPCRoleEntity::new, class_1311.field_17715)
                            .method_5905(of("base_character")),
                    BaseNPCLikeEntity::createAttributes
            );
    public static final class_1299<DanmakuEntity> DANMAKU =
            registerEntity("danmaku_bullet",
                    class_1299.class_1300.<DanmakuEntity>method_5903(DanmakuEntity::new, class_1311.field_17715)
                            .method_5905(of("danmaku_bullet")));
    public static final class_1299<BaguaFurnaceEntity> BAGUA_FURNACE =
            registerEntity("bagua_furnace",
                    class_1299.class_1300.<BaguaFurnaceEntity>method_5903(BaguaFurnaceEntity::new, class_1311.field_17715)
                            .method_5905(of("bagua_furnace"))
            );
    public static final class_1299<KnifeEntity> KNIFE =
            registerEntity("knife",
                    class_1299.class_1300.<KnifeEntity>method_5903(KnifeEntity::new, class_1311.field_17715)
                            .method_5905(of("knife")));
    public static final class_1299<OreEspEntity> ORE_ESP =
            registerEntity("ore_esp_entity",
                    class_1299.class_1300.<OreEspEntity>method_5903(OreEspEntity::new, class_1311.field_17715)
                            .method_5905(of("ore_esp_entity")));
    public static final class_1299<FumoSellerVillager> FUMO_SELLER_VILLAGER =
            registerEntityWithSpawnEgg("fumo_seller_villager",
                    class_1299.class_1300.<FumoSellerVillager>method_5903(FumoSellerVillager::new, class_1311.field_17715)
                            .method_17687(0.6f, 1.95f).method_55687(1.62f).method_27299(10)
                            .method_5905(of("fumo_seller_villager")),
                    FumoSellerVillager::method_26827
            );
    public static final class_1299<MagicBroomEntity> MAGIC_BROOM = registerEntityWithSpawnEgg("broom",
            class_1299.class_1300.<MagicBroomEntity>method_5903(MagicBroomEntity::new, class_1311.field_17715)
                    .method_5905(of("broom")),
            MagicBroomEntity::createAttributes);
    public static final class_1299<WheelchairEntity> WHEEL_CHAIR = registerEntityWithSpawnEgg("wheel_chair",
            class_1299.class_1300.<WheelchairEntity>method_5903(WheelchairEntity::new, class_1311.field_17715)
                    .method_5905(of("wheel_chair")),
            WheelchairEntity::createAttributes);
    public static final class_1299<ScarecrowEntity> SCARECROW = registerEntityWithSpawnEgg("scarecrow",
            class_1299.class_1300.<ScarecrowEntity>method_5903(ScarecrowEntity::new, class_1311.field_17715)
                    .method_5905(of("scarecrow")),
            ScarecrowEntity::method_26827
    );
    public static final class_1299<KillerBeeEntity> KILLER_BEE = registerEntityWithSpawnEgg("killer_bee",
            class_1299.class_1300.<KillerBeeEntity>method_5903(KillerBeeEntity::new, class_1311.field_6302)
                    .method_5905(of("killer_bee")),
            () -> class_1429.method_61457()
                    .method_26868(class_5134.field_23716, 10.0)
                    .method_26868(class_5134.field_23720, 0.6f)
                    .method_26868(class_5134.field_23719, 0.3f)
                    .method_26868(class_5134.field_23721, 2.0)
                    .method_26868(class_5134.field_47760, 1.5f)
    );
    public static final class_1299<MoonRabbitEntity> MOON_RABBIT = registerEntityWithSpawnEgg("moon_rabbit",
            class_1299.class_1300.<MoonRabbitEntity>method_5903(MoonRabbitEntity::new, class_1311.field_6302)
                    .method_5905(of("moon_rabbit")),
            () -> class_1309.method_26827()
                    .method_26868(class_5134.field_23716, 18.0)
                    .method_26868(class_5134.field_23719, 0.12)
                    .method_26868(class_5134.field_23721, 3)
                    .method_26868(class_5134.field_47760, 1.2f)
                    .method_26868(class_5134.field_23718, 0.1)
                    .method_26868(class_5134.field_23717, 8.0)
                    .method_26868(class_5134.field_52450, 10.0)
                    .method_26868(class_5134.field_47759, 3)
    );
    public static final class_1299<GhostEntity> GHOST = registerEntityWithSpawnEgg("ghost",
            class_1299.class_1300.<GhostEntity>method_5903(GhostEntity::new, class_1311.field_6302)
                    .method_5905(of("ghost")),
            () -> class_1309.method_26827()
                    .method_26868(class_5134.field_23716, 20.0)
                    .method_26868(class_5134.field_23719, 0.1)
                    .method_26868(class_5134.field_23721, 3)
                    .method_26868(class_5134.field_47760, 0.8f)
                    .method_26868(class_5134.field_23718, 0.1)
                    .method_26868(class_5134.field_23717, 8.0)
                    .method_26868(class_5134.field_52450, 10.0)
                    .method_26868(class_5134.field_47759, 3)
    );
    public static final class_1299<YouseiEntity> YOUSEI = registerEntityWithSpawnEgg("yousei",
            class_1299.class_1300.<YouseiEntity>method_5903(YouseiEntity::new, class_1311.field_6302)
                    .method_5905(of("yousei")),
            () -> class_1309.method_26827()
                    .method_26868(class_5134.field_23716, 25.0)
                    .method_26868(class_5134.field_23720, 0.8f)
                    .method_26868(class_5134.field_23719, 0.15f)
                    .method_26868(class_5134.field_23721, 0.5)
                    .method_26868(class_5134.field_47760, 1.8f)
                    .method_26868(class_5134.field_23718, 0.1)
                    .method_26868(class_5134.field_23717, 16.0)
                    .method_26868(class_5134.field_52450, 10.0)
                    .method_26868(class_5134.field_47759, 3)
    );
    public static final class_1299<MaidYouseiEntity> MAID_YOUSEI = registerEntityWithSpawnEgg("maid_yousei",
            class_1299.class_1300.<MaidYouseiEntity>method_5903(MaidYouseiEntity::new, class_1311.field_6302)
                    .method_5905(of("maid_yousei")),
            () -> class_1309.method_26827()
                    .method_26868(class_5134.field_23716, 25.0)
                    .method_26868(class_5134.field_23720, 0.8f)
                    .method_26868(class_5134.field_23719, 0.15f)
                    .method_26868(class_5134.field_23721, 0.5)
                    .method_26868(class_5134.field_47760, 1.8f)
                    .method_26868(class_5134.field_23718, 0.1)
                    .method_26868(class_5134.field_23717, 16.0)
                    .method_26868(class_5134.field_52450, 10.0)
                    .method_26868(class_5134.field_47759, 3)
    );
    public static final class_1299<SunflowerYouseiEntity> SUNFLOWER_YOUSEI = registerEntityWithSpawnEgg("sunflower_yousei",
            class_1299.class_1300.<SunflowerYouseiEntity>method_5903((type, world) -> new SunflowerYouseiEntity(type, world, MobSkinTypes.SUNFLOWER_YOUSEI), class_1311.field_6302)
                    .method_5905(of("sunflower_yousei")),
            () -> class_1309.method_26827()
                    .method_26868(class_5134.field_23716, 30.0)
                    .method_26868(class_5134.field_23720, 0.8f)
                    .method_26868(class_5134.field_23719, 0.15f)
                    .method_26868(class_5134.field_23721, 0.5)
                    .method_26868(class_5134.field_47760, 0.6f)
                    .method_26868(class_5134.field_23718, 0.1)
                    .method_26868(class_5134.field_23717, 16.0)
                    .method_26868(class_5134.field_52450, 10.0)
                    .method_26868(class_5134.field_47759, 3)
    );
    public static final class_1299<GoblinEntity> GOBLIN = registerEntityWithSpawnEgg("goblin",
            class_1299.class_1300.<GoblinEntity>method_5903(GoblinEntity::new, class_1311.field_6302)
                    .method_5905(of("goblin")),
            () -> class_1309.method_26827()
                    .method_26868(class_5134.field_23716, 30.0)
                    .method_26868(class_5134.field_23720, 0.8f)
                    .method_26868(class_5134.field_23719, 0.2f)
                    .method_26868(class_5134.field_23721, 1f)
                    .method_26868(class_5134.field_47760, 1f)
                    .method_26868(class_5134.field_23718, 0.1f)
                    .method_26868(class_5134.field_23717, 16.0f)
                    .method_26868(class_5134.field_52450, 10.0f)
                    .method_26868(class_5134.field_47759, 3)
    );
    public static final class_1299<WaterElementalEntity> WATER_ELEMENTAL = registerEntityWithSpawnEgg("water_elemental",
            class_1299.class_1300.<WaterElementalEntity>method_5903(WaterElementalEntity::new, class_1311.field_6302)
                    .method_5905(of("water_elemental")),
            WaterElementalEntity::createAttributes
    );
    public static final class_1299<FireElementalEntity> FIRE_ELEMENTAL = registerEntityWithSpawnEgg("fire_elemental",
            class_1299.class_1300.<FireElementalEntity>method_5903(FireElementalEntity::new, class_1311.field_6302)
                    .method_5905(of("fire_elemental")),
            FireElementalEntity::createAttributes
    );
    public static final class_1299<IceElementalEntity> ICE_ELEMENTAL = registerEntityWithSpawnEgg("ice_elemental",
            class_1299.class_1300.<IceElementalEntity>method_5903(IceElementalEntity::new, class_1311.field_6302)
                    .method_5905(of("ice_elemental")),
            IceElementalEntity::createAttributes
    );
    public static final class_1299<HairballEntity> HAIRBALL = registerEntityWithSpawnEgg("hairball",
            class_1299.class_1300.<HairballEntity>method_5903(HairballEntity::new, class_1311.field_6302)
                    .method_5905(of("hairball")),
            HairballEntity::createAttributes
    );
    public static final class_1299<UfoEntity> UFO = registerEntityWithSpawnEgg("ufo",
            class_1299.class_1300.<UfoEntity>method_5903(UfoEntity::new, class_1311.field_6302)
                    .method_17687(1.5f, 1.5f)
                    .method_5905(of("ufo")),
            UfoEntity::method_26828
    );
    public static final class_1299<MushroomMonsterEntity> MUSHROOM_MONSTER = registerEntityWithSpawnEgg("mushroom_monster",
            class_1299.class_1300.<MushroomMonsterEntity>method_5903(MushroomMonsterEntity::new, class_1311.field_6302)
                    .method_5905(of("mushroom_monster")),
            MushroomMonsterEntity::createAttributes
    );
    public static final class_1299<WildPigEntity> WILD_PIG =
            registerEntityWithSpawnEgg("wild_pig",
                    class_1299.class_1300.<WildPigEntity>method_5903(WildPigEntity::new, class_1311.field_6302)
                            .method_5905(of("wild_pig")),
                    () -> class_1429.method_61457()
                            .method_26868(class_5134.field_23716, 20.0)
                            .method_26868(class_5134.field_23720, 0.6f)
                            .method_26868(class_5134.field_23719, 0.3f)
                            .method_26868(class_5134.field_23721, 2.0)
                            .method_26868(class_5134.field_47760, 1.5f)
            );
    public static final class_1299<TavernVillager> TAVERN_VILLAGER =
            registerEntityWithSpawnEgg("tavern_villager",
                    class_1299.class_1300.<TavernVillager>method_5903(TavernVillager::new, class_1311.field_17715)
                            .method_17687(0.6f, 1.95f).method_55687(1.62f).method_27299(10)
                            .method_5905(of("tavern_villager")),
                    TavernVillager::method_26827
            );

    public static void registerEntityTypes() {
        DynamicRegistryManagerCallback.Builder<class_10586> pigVariantBuilder = DynamicRegistryManagerCallback.createBuilder(class_7924.field_55883);
        pigVariantBuilder.register(ReverieDreams.id("wild_pig"), new class_10586(
                new class_10693<>(class_10586.class_10587.field_55688, ReverieDreams.id("entity/pig/wild_pig")),
                class_10702.field_56285
        ));
        BiomeModifications.addSpawn(
                BiomeSelectors.tag(ConventionalBiomeTags.IS_FOREST),
                class_1311.field_6302,
                RDEntityTypes.WILD_PIG,
                1,
                1,
                3
        );
    }

    public static class_5321<class_1299<?>> of(String name) {
        return class_5321.method_29179(class_7924.field_41266, ReverieDreams.id(name));
    }

    public static <T extends class_1297> class_1299<T> registerEntity(String path, class_1299<T> entityType) {
        class_1299<T> entityTypeRef = class_2378.method_10230(class_7923.field_41177, ReverieDreams.id(path), entityType);
        ENTITY_TYPES.add(entityType);
        return entityTypeRef;
    }

    public static <T extends class_1297> class_1299<T> registerEntity(String path, @NotNull class_1299<T> entityType, CreateAttributesFunction createAttributesFunction) {
        registerEntity(path, entityType);
        FabricDefaultAttributeRegistry.register((class_1299<class_1308>) entityType, createAttributesFunction.apply());
        return entityType;
    }

    public static <T extends class_1297> @NotNull class_1299<T> registerEntityWithSpawnEgg(String path, class_1299<T> entityType, CreateAttributesFunction createAttributesFunction) {
        class_1299<T> entityTypeRef = class_2378.method_10230(class_7923.field_41177, ReverieDreams.id(path), entityType);
        FabricDefaultAttributeRegistry.register((class_1299<? extends class_1308>) entityTypeRef, createAttributesFunction.apply());
        class_1792 item = registerSpawnEggItem(new SpawnEggItem(path + "_spawn_egg", (class_1299<? extends class_1308>) entityTypeRef, new class_1792.class_1793()));
        SPAWN_EGG_ITEM_LIST.add(item);
        SPAWN_EGG_BIND.put(entityTypeRef, item);
        return entityTypeRef;
    }

    public static <T extends class_1297> class_1299<T> registerEntityWithSpawnEgg(String path, class_1299<T> entityType, CreateAttributesBuilderFunction createAttributesFunction) {
        return registerEntityWithSpawnEgg(path, entityType, () -> createAttributesFunction.apply().method_26866());
    }

    @FunctionalInterface
    public interface CreateAttributesFunction {
        class_5132 apply();
    }

    @FunctionalInterface
    public interface CreateAttributesBuilderFunction {
        class_5132.class_5133 apply();
    }
}
