package cc.thonly.reverie_dreams.registry.impl;

import cc.thonly.registry_modifier.mixin.NamedAccessor;
import cc.thonly.reverie_dreams.registry.interfaces.BuiltinObject;
import cc.thonly.reverie_dreams.registry.interfaces.Initialization;
import cc.thonly.reverie_dreams.registry.interfaces.OwnerBinding;
import cc.thonly.reverie_dreams.registry.interfaces.ReloadStep;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_156;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3503;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7871;
import net.minecraft.class_9248;
import net.minecraft.core.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Slf4j
@SuppressWarnings("deprecation")
public class RegistryHandler<T> implements class_2385<T> {
    private final class_5321<? extends class_2378<T>> key;
    private final Map<class_2960, class_6880.class_6883<T>> idToEntry;
    private final Map<class_5321<T>, class_6880.class_6883<T>> keyToEntry;
    private final HashBiMap<Integer, class_6880.class_6883<T>> rawIdToEntry;
    private final Map<T, class_6880.class_6883<T>> valueToEntry;
    private final Map<class_5321<T>, class_9248> keyToEntryInfo;
    private final List<Initialization<T>> builders = new LinkedList<>();
    private final List<ReloadStep<T>> reloadableSteps = new LinkedList<>();
    private final Map<class_2960, T> builtins = new Object2ObjectLinkedOpenHashMap<>();
    private final Map<class_6862<T>, class_6885.class_6888<T>> tags = new Object2ObjectLinkedOpenHashMap<>();
    private final Lifecycle lifecycle;
    private class_2960 defaultId;
    private boolean frozen = false;
    @Getter
    private boolean reloadable = false;
    @Getter
    private Codec<T> codec;
    @Nullable
    @Getter
    private RegistryHandler<T> parent;

    public RegistryHandler(class_5321<? extends class_2378<T>> key) {
        this(key, Lifecycle.stable());
    }

    public RegistryHandler(class_5321<? extends class_2378<T>> key, Lifecycle lifecycle) {
        this.key = key;
        this.lifecycle = lifecycle;
        this.idToEntry = new Object2ObjectLinkedOpenHashMap<>();
        this.keyToEntry = new Object2ObjectLinkedOpenHashMap<>();
        this.rawIdToEntry = HashBiMap.create();
        this.valueToEntry = new Object2ObjectLinkedOpenHashMap<>();
        this.keyToEntryInfo = new Object2ObjectLinkedOpenHashMap<>();
    }

    public RegistryHandler(class_5321<? extends class_2378<T>> key, @Nullable RegistryHandler<T> parent) {
        this(key, Lifecycle.stable(), parent);
    }

    public RegistryHandler(class_5321<? extends class_2378<T>> key, Lifecycle lifecycle, @Nullable RegistryHandler<T> parent) {
        this(key, lifecycle);
        this.parent = parent;
    }

    public void validate() {
        AtomicInteger next = new AtomicInteger();
        this.keyToEntry.forEach((registryKey, reference) -> {
            if (registryKey == null)  {
                log.error("Can't verify registry key, rawId: {}", next.get());
                return;
            }
            if (reference == null) {
                log.error("Can't verify registry entry reference, registryKey: {}", registryKey);
                return;
            }
            if (reference.comp_349() == null) {
                log.error("Can't verify registry entry value, registryKey: {}", registryKey);
                return;
            }
            next.getAndIncrement();
        });
    }

    public RegistryHandler<T> shadow() {
        return new RegistryHandler<>(this.key, this);
    }

    public Set<Map.Entry<class_2960, T>> idEntrySet() {
        return this.method_29722().stream()
                .collect(Collectors.toMap(
                        entry -> entry.getKey().method_29177(),
                        Map.Entry::getValue
                )).entrySet();
    }

    public RegistryHandler<T> build() {
        if (this.frozen) {
            return this;
        }
        this.builders.forEach(step -> step.bootstrap(this));
        this.method_40276();
        return this;
    }

    public RegistryHandler<T> builder(Initialization<T>... initializations) {
        this.builders.addAll(Arrays.asList(initializations));
        return this;
    }

    public RegistryHandler<T> reloadBuilder(ReloadStep<T>... steps) {
        this.reloadableSteps.addAll(Arrays.asList(steps));
        this.reloadable = true;
        return this;
    }

    public RegistryHandler<T> codec(Codec<T> codec) {
        this.codec = codec;
        return this;
    }

    public RegistryHandler<T> defaultId(class_2960 defaultId) {
        this.defaultId = defaultId;
        return this;
    }

    public void clear() {
        this.idToEntry.clear();
        this.keyToEntry.clear();
        this.rawIdToEntry.clear();
        this.valueToEntry.clear();
        this.keyToEntryInfo.clear();
    }

    public void reload(class_3300 manager) {
        this.idToEntry.clear();
        this.keyToEntry.clear();
        this.rawIdToEntry.clear();
        this.valueToEntry.clear();
        this.keyToEntryInfo.clear();
        for (Map.Entry<class_2960, T> ivMapEntry : this.builtins.entrySet()) {
            class_2960 key = ivMapEntry.getKey();
            T value = ivMapEntry.getValue();
            this.method_10272(class_5321.method_29179(this.key, key), value, class_9248.field_49136);
        }
        for (ReloadStep<T> step : this.reloadableSteps) {
            step.reload(manager);
        }
    }

    public Stream<Map.Entry<class_2960, T>> streamIdToValue() {
        return this.idToEntry.entrySet().stream().collect(Collectors.toMap(
                Map.Entry::getKey,
                entry -> entry.getValue().comp_349()
        )).entrySet().stream();
    }

    public Map<Integer, class_6880.class_6883<T>> getIdToEntryMap() {
        return Map.copyOf(this.rawIdToEntry);
    }

    public Set<class_2960> keys() {
        return new LinkedHashSet<>(this.idToEntry.keySet());
    }

    public Set<T> values() {
        return new LinkedHashSet<>(this.valueToEntry.keySet());
    }

    public void setBuiltin(class_2960 id, T value) {
        if (this.builtins.containsKey(id) || this.builtins.containsValue(value)) {
            return;
        }
        this.builtins.put(id, value);
    }

    @Override
    public class_6880.class_6883<T> method_10272(class_5321<T> key, T value, class_9248 info) {
        class_2960 id = key.method_29177();
        class_6880.class_6883<T> entry = method_40269(value);
        entry.method_45917(key);
        this.idToEntry.put(id, entry);
        this.keyToEntry.put(key, entry);
        this.rawIdToEntry.put(this.idToEntry.size() - 1, entry);
        this.valueToEntry.put(value, entry);
        this.keyToEntryInfo.put(key, info);
        if (value instanceof BuiltinObject) {
            this.builtins.put(id, value);
        }
        if (value instanceof OwnerBinding<?>) {
            //noinspection unchecked
            OwnerBinding<T> ownerBinding = (OwnerBinding<T>) value;
            ownerBinding.setOwner(this);
        }
        return entry;
    }

    public class_6880.class_6883<T> set(class_5321<T> key, T value, class_9248 info) {
        if (!this.keyToEntry.containsKey(key)) {
            return this.method_10272(key, value, info);
        }
        class_2960 id = key.method_29177();
        Optional<class_6880.class_6883<T>> oldEntry = this.method_10223(id);
        if (oldEntry.isEmpty()) {
            log.error("Can't find prev value in registry {}", this.key);
            Optional<class_6880.class_6883<T>> defaultEntry = this.method_60385();
            return defaultEntry.orElse(null);
        }

        this.builtins.remove(id);
        int oldRawId = this.rawIdToEntry.inverse().get(oldEntry.get());
        this.rawIdToEntry.remove(oldRawId);

        class_6880.class_6883<T> entry = method_40269(value);
        entry.method_45917(key);
        this.idToEntry.put(id, entry);
        this.keyToEntry.put(key, entry);
        this.rawIdToEntry.put(oldRawId, entry);
        this.valueToEntry.put(value, entry);
        this.keyToEntryInfo.put(key, info);
        if (value instanceof BuiltinObject) {
            this.builtins.put(id, value);
        }
        return entry;
    }

    @Override
    public void method_62681(class_6862<T> tag, List<class_6880<T>> registryEntries) {
        class_6885.class_6888<T> entryListNamed = NamedAccessor.callNew(this, tag);
        this.tags.put(tag, entryListNamed);
        entryListNamed.field_36460 = new ArrayList<>(registryEntries);
    }

    @Override
    public boolean method_35863() {
        return this.keyToEntry.isEmpty();
    }

    @Override
    public class_7871<T> method_46769() {
        return new class_7871<T>() {
            public Optional<class_6880.class_6883<T>> method_46746(class_5321<T> key) {
                return Optional.of(this.method_46747(key));
            }

            public class_6880.class_6883<T> method_46747(class_5321<T> key) {
                return RegistryHandler.this.getOrCreateEntry(key);
            }

            public Optional<class_6885.class_6888<T>> method_46733(class_6862<T> tag) {
                return Optional.of(this.method_46735(tag));
            }

            public class_6885.class_6888<T> method_46735(class_6862<T> tag) {
                return RegistryHandler.this.getTag(tag);
            }
        };
    }

    @Override
    public class_5321<? extends class_2378<T>> method_46765() {
        return this.key;
    }

    @Override
    public Lifecycle method_46766() {
        return this.lifecycle;
    }

    @Override
    public @Nullable class_2960 method_10221(T value) {
        for (Map.Entry<class_2960, class_6880.class_6883<T>> mapEntry : this.idToEntry.entrySet()) {
            if (mapEntry.getValue().comp_349().equals(value)) {
                return mapEntry.getKey();
            }
        }
        return null;
    }

    @Override
    public Optional<class_5321<T>> method_29113(T value) {
        class_6880.class_6883<T> ref = this.valueToEntry.get(value);
        return ref != null && ref.method_40227() ? Optional.of(ref.method_40237()) : Optional.empty();
    }

    @Override
    public int method_10206(@Nullable T value) {
        Optional<class_6880.class_6883<T>> entry = this.method_10223(this.method_10221(value));
        if (entry.isEmpty()) {
            return -1;
        }
        return this.rawIdToEntry.inverse().get(entry.get());
    }

    @Override
    public @Nullable T method_10200(int index) {
        class_6880.class_6883<T> tReference = this.rawIdToEntry.get(index);
        if (tReference == null) {
            return null;
        }
        return tReference.comp_349();
    }

    @Override
    public int method_10204() {
        return this.keyToEntry.size();
    }

    @Override
    public @Nullable T method_29107(@Nullable class_5321<T> key) {
        class_6880.class_6883<T> entry = this.keyToEntry.get(key);
        if (entry == null) {
            class_6880.class_6883<T> tReference = this.method_60385().orElse(null);
            if (tReference == null) {
                return null;
            }
            return tReference.comp_349();
        }
        return entry.comp_349();
    }

    @Override
    public @Nullable T method_63535(@Nullable class_2960 id) {
        if (id == null) {
            return this.method_60385().map(class_6880::comp_349).orElse(null);
        }
        class_6880.class_6883<T> ref = this.idToEntry.get(id);
        if (ref != null) {
            return ref.comp_349();
        }
        return this.method_60385().map(class_6880::comp_349).orElse(null);
    }


    @Override
    public Optional<class_9248> method_57058(class_5321<T> key) {
        return Optional.ofNullable(this.keyToEntryInfo.get(key));
    }

    @Override
    public Optional<class_6880.class_6883<T>> method_60385() {
        return this.method_10223(this.defaultId);
    }

    @Override
    public Set<class_2960> method_10235() {
        return Set.copyOf(this.idToEntry.keySet());
    }

    @Override
    public Set<Map.Entry<class_5321<T>, T>> method_29722() {
        return Collections.unmodifiableSet(class_156.method_65967(this.keyToEntry, class_6880::comp_349).entrySet());
    }

    @Override
    public Set<class_5321<T>> method_42021() {
        return Set.copyOf(this.keyToEntry.keySet());
    }

    @Override
    public Optional<class_6880.class_6883<T>> method_10240(class_5819 random) {
        return class_156.method_40083(this.idToEntry.values().stream().toList(), random);
    }

    @Override
    public boolean method_10250(class_2960 id) {
        return this.idToEntry.containsKey(id);
    }

    @Override
    public boolean method_35842(class_5321<T> key) {
        return this.keyToEntry.containsKey(key);
    }

    @Override
    public class_2378<T> method_40276() {
        this.frozen = true;
        return this;
    }

    public class_2378<T> unfreeze() {
        this.frozen = false;
        return this;
    }

    @Override
    public class_6880.class_6883<T> method_40269(T value) {
        return class_6880.class_6883.method_40233(this, value);
    }

    class_6880.class_6883<T> getOrCreateEntry(class_5321<T> key) {
        return this.keyToEntry.computeIfAbsent(key, (key2) -> class_6880.class_6883.method_40234(this, key2));
    }

    class_6885.class_6888<T> getTag(class_6862<T> key) {
        return this.tags.computeIfAbsent(key, this::createNamedEntryList);
    }

    private class_6885.class_6888<T> createNamedEntryList(class_6862<T> tag) {
        return NamedAccessor.callNew(this, tag);
    }

    @Override
    public Optional<class_6880.class_6883<T>> method_40265(int rawId) {
        return Optional.ofNullable(this.rawIdToEntry.get(rawId));
    }

    @Override
    public Optional<class_6880.class_6883<T>> method_10223(class_2960 id) {
        return Optional.ofNullable(this.idToEntry.get(id));
    }

    @Override
    public class_6880<T> method_47983(T value) {
        class_6880.class_6883<T> reference = this.valueToEntry.get(value);
        return (reference != null ? reference : class_6880.method_40223(value));
    }

    @Override
    public Stream<class_6885.class_6888<T>> method_40272() {
        return Stream.empty();
    }

    @Override
    public class_10106<T> method_62683(class_3503.class_6863<T> tags) {
        return null;
    }

    @Override
    public @NotNull Iterator<T> iterator() {
        return this.keyToEntry.values().stream().map(class_6880::comp_349).iterator();
    }

    @Override
    public Stream<class_6880.class_6883<T>> method_42017() {
        return this.keyToEntry.values().stream();
    }

    @Override
    public Stream<class_6885.class_6888<T>> method_42020() {
        return this.tags.values().stream();
    }

    @Override
    public Optional<class_6880.class_6883<T>> method_46746(class_5321<T> key) {
        return this.method_10223(key.method_29177());
    }

    @Override
    public Optional<class_6885.class_6888<T>> method_46733(class_6862<T> tag) {
        return Optional.ofNullable(this.tags.get(tag));
    }
}
