package cc.thonly.reverie_dreams.registry.impl;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.api.RegistryManagerReloadCallback;
import cc.thonly.reverie_dreams.data.CustomCharacterLoader;
import cc.thonly.reverie_dreams.recipe.RecipeManager;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.server.CookingInputRecipeManager;
import cc.thonly.reverie_dreams.server.ItemCateManager;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;


public class ServerResourceHelper {
    public static void init() {
        ResourceManagerHelper helper = ResourceManagerHelper.get(class_3264.field_14190);
        helper.registerReloadListener(new Listener());
    }

    public static class Listener implements SimpleSynchronousResourceReloadListener {
        @Override
        public class_2960 getFabricId() {
            return ReverieDreams.id("data");
        }

        @Override
        public void method_14491(class_3300 manager) {
            RecipeManager.onReload(manager);
            for (var entry : RegistryHandlers.ROOT.entrySet()) {
                RegistryHandler<?> registry = entry.getValue();
                if (registry.isReloadable()) {
                    registry.reload(manager);
                    RegistryManagerReloadCallback.EVENT.invoker().onLoad(registry);
                }
                registry.validate();
            }
            this.onLoad(manager);
            CookingInputRecipeManager.getInstance().clearItems();
            ItemCateManager.getInstance().clearTags();
            CustomCharacterLoader.reload();
        }

        public void onLoad(class_3300 manager) {

        }
    }
}
