package cc.thonly.reverie_dreams.server;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_5250;

public class ItemDescriptionManager {
    private static final Map<class_1792, List<class_5250>> REGISTRIES = new Object2ObjectOpenHashMap<>();

    public static void bootstrap() {

    }

    public static void register(class_1792 item, class_5250... texts) {
        List<class_5250> registry = REGISTRIES.computeIfAbsent(item, i -> new ArrayList<>());
        registry.addAll(Arrays.asList(texts));
    }

    public static void register(class_1792 item, List<class_5250> texts) {
        List<class_5250> registry = REGISTRIES.computeIfAbsent(item, i -> new ArrayList<>());
        registry.addAll(texts);
    }

    public static List<class_5250> getDescription(class_1792 item) {
        return REGISTRIES.getOrDefault(item, new ArrayList<>());
    }
}
