package cc.thonly.reverie_dreams.util.entity;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.util.ConstantInfo;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.file.loader.AjBlueprintLoader;
import de.tomalbrc.bil.file.loader.AjModelLoader;
import de.tomalbrc.bil.file.loader.BbModelLoader;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_2960;
import java.util.function.Function;

@Slf4j
public class ModelUtil {
    public static class_2960 id(String path) {
        return ReverieDreams.id(path);
    }

    public static Model loadModel(class_2960 id, Function<class_2960, Model> function) {
        try {
            var model = function.apply(id);
            if (ConstantInfo.isDevMode()) {
                log.info("Loaded model {}", id);
            }
            return model;
        } catch (Exception e) {
            log.error("Can't load model {}", id.toString(), e);
            throw e;
        }
    }

    public static Model loadBBModel(class_2960 id) {
        return loadModel(id, BbModelLoader::load);
    }

    public static Model loadAjModel(class_2960 id) {
        return loadModel(id, AjModelLoader::load);
    }

    public static Model loadAjBlueprint(class_2960 id) {
        return loadModel(id, AjBlueprintLoader::load);
    }

}
