package cc.thonly.reverie_dreams.world;

import cc.thonly.reverie_dreams.config.ReverieDreamsConfiguration;
import cc.thonly.reverie_dreams.entity.elemental.IceElementalEntity;
import cc.thonly.reverie_dreams.registry.content.entity.RDEntityTypes;
import cc.thonly.reverie_dreams.world.gen.BiomeInit;
import cc.thonly.reverie_dreams.world.gen.PlacedFeaturesInit;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5483;
import net.minecraft.class_9169;
import net.minecraft.world.entity.*;
import java.util.Random;

public class BiomeModificationInit {
    public static final int BASE_WEIGHT = 80;

    public static void init() {
        addBlock();
        addFlower();
        addTree();
        addEntity();
        addStructure();
    }

    public static void addTree() {
        BiomeModifications.addFeature(BiomeSelectors.includeByKey(class_1972.field_9412, class_1972.field_9449),
                class_2893.class_2895.field_13178, PlacedFeaturesInit.SPIRITUAL_TREE_KEY);
        BiomeModifications.addFeature(BiomeSelectors.includeByKey(class_1972.field_9409),
                class_2893.class_2895.field_13178, PlacedFeaturesInit.LEMON_TREE_KEY);
        BiomeModifications.addFeature(BiomeSelectors.includeByKey(class_1972.field_9449, class_1972.field_9417),
                class_2893.class_2895.field_13178, PlacedFeaturesInit.GINKGO_TREE_KEY);
        BiomeModifications.addFeature(BiomeSelectors.includeByKey(class_1972.field_9409, class_1972.field_9417),
                class_2893.class_2895.field_13178, PlacedFeaturesInit.PEACH_TREE_KEY);
    }

    public static void addBlock() {
        // 银矿石
        BiomeModifications.addFeature(
                BiomeSelectors.foundInOverworld(),
                class_2893.class_2895.field_13176,
                PlacedFeaturesInit.OVERWORLD_SILVER_ORE_KEY
        );
        // 宝玉矿石
        BiomeModifications.addFeature(
                BiomeSelectors.foundInOverworld(),
                class_2893.class_2895.field_13176,
                PlacedFeaturesInit.OVERWORLD_ORB_ORE_KEY
        );
    }

    public static void addFlower() {
        BiomeModifications.addFeature(
                BiomeSelectors.includeByKey(class_1972.field_35117, class_1972.field_9414),
                class_2893.class_2895.field_13178,
                PlacedFeaturesInit.UDUMBARA_FLOWER_KEY
        );
        // 银耳丛
        BiomeModifications.addFeature(
                BiomeSelectors.includeByKey(class_1972.field_9409, class_1972.field_9475, class_1972.field_9412),
                class_2893.class_2895.field_13178,
                PlacedFeaturesInit.TREMELLA_KEY
        );
    }

    public static void addEntity() {
        // 妖精大类
        if (ReverieDreamsConfiguration.ENABLE_YOUSEI_SPAWN) {
            // 普通妖精
            BiomeModifications.addSpawn(
                    BiomeSelectors.tag(ConventionalBiomeTags.IS_PLAINS),
                    class_1311.field_6302,
                    RDEntityTypes.YOUSEI, 10, 1, 2
            );
            BiomeModifications.addSpawn(
                    BiomeSelectors.includeByKey(BiomeInit.DREAM),
                    class_1311.field_6302,
                    RDEntityTypes.YOUSEI, 2, 1, 2
            );
            class_1317.method_20637(
                    RDEntityTypes.YOUSEI,
                    class_9169.field_48745,
                    class_2902.class_2903.field_13203,
                    (entityType, world, reason, pos, random) -> {
                        if (!world.method_8320(pos.method_10074()).method_27852(class_2246.field_10219)) return false;
                        if (world.method_22335(pos, 0) <= 8) return false;
                        if (!world.method_8320(pos).method_26215()) return false;

                        int nearby = world.method_18467(
                                RDEntityTypes.YOUSEI.method_31794(),
                                new class_238(
                                        pos.method_10263() - 8, pos.method_10264() - 4, pos.method_10260() - 8,
                                        pos.method_10263() + 8, pos.method_10264() + 4, pos.method_10260() + 8
                                )
                        ).size();

                        if (nearby > 2) return false;
                        return random.method_43057() < 0.6f;
                    }
            );
            // 向日葵妖精
            BiomeModifications.addSpawn(
                    BiomeSelectors.tag(ConventionalBiomeTags.IS_PLAINS),
                    class_1311.field_6302,
                    RDEntityTypes.SUNFLOWER_YOUSEI, 3, 1, 3
            );
            BiomeModifications.addSpawn(
                    BiomeSelectors.includeByKey(BiomeInit.DREAM),
                    class_1311.field_6302,
                    RDEntityTypes.SUNFLOWER_YOUSEI, 1, 1, 1
            );
            class_1317.method_20637(
                    RDEntityTypes.SUNFLOWER_YOUSEI,
                    class_9169.field_48745,
                    class_2902.class_2903.field_13203,
                    (entityType, world, reason, pos, random) -> {
                        // 原本条件
                        if (!world.method_8320(pos.method_10074()).method_27852(class_2246.field_10219)) return false;
                        if (world.method_22335(pos, 0) <= 8) return false;
                        if (!world.method_8320(pos).method_26215()) return false;

                        // 检测周围是否已有太多该实体
                        int nearbyCount = world.method_18467(
                                RDEntityTypes.SUNFLOWER_YOUSEI.method_31794(),
                                new class_238(
                                        pos.method_10263() - 8, pos.method_10264() - 4, pos.method_10260() - 8,
                                        pos.method_10263() + 8, pos.method_10264() + 4, pos.method_10260() + 8
                                )
                        ).size();

                        return nearbyCount < 3; // 附近 16x8x16 范围内少于 3 个才允许生成
                    }
            );
            // 女仆妖精
            BiomeModifications.addSpawn(
                    BiomeSelectors.tag(ConventionalBiomeTags.IS_DARK_FOREST),
                    class_1311.field_6302,
                    RDEntityTypes.MAID_YOUSEI, 10, 1, 2
            );
        }

        // 杀人蜂
        BiomeModifications.addSpawn(
                BiomeSelectors.tag(ConventionalBiomeTags.IS_BIRCH_FOREST),
                class_1311.field_6302,
                RDEntityTypes.KILLER_BEE, 7, 2, 3
        );
        // 毛玉
        BiomeModifications.addSpawn(
                BiomeSelectors.tag(ConventionalBiomeTags.IS_FOREST),
                class_1311.field_6302,
                RDEntityTypes.HAIRBALL, 10, 2, 4
        );
        // 哥布林
        BiomeModifications.addSpawn(
                BiomeSelectors.tag(ConventionalBiomeTags.IS_DESERT),
                class_1311.field_6302,
                RDEntityTypes.GOBLIN, 50 / 5, 1, 1
        );
        class_1317.method_20637(
                RDEntityTypes.GOBLIN,
                class_9169.field_48745,
                class_2902.class_2903.field_13203,
                (entity, world, reason, pos, random) ->
                        world.method_8320(pos.method_10074()).method_27852(class_2246.field_10219) &&
                                world.method_22335(pos, 0) > 8 &&
                                world.method_8320(pos).method_26215()
        );
        // 蘑菇怪
        BiomeModifications.addSpawn(
                BiomeSelectors.tag(ConventionalBiomeTags.IS_MUSHROOM),
                class_1311.field_6302,
                RDEntityTypes.MUSHROOM_MONSTER, 8, 1, 2
        );
        BiomeModifications.addSpawn(
                BiomeSelectors.tag(ConventionalBiomeTags.IS_DARK_FOREST),
                class_1311.field_6302,
                RDEntityTypes.MUSHROOM_MONSTER, 8, 1, 2
        );
        // 冰元素
        BiomeModifications.addSpawn(
                BiomeSelectors.tag(ConventionalBiomeTags.IS_SNOWY),
                class_1311.field_6302,
                RDEntityTypes.ICE_ELEMENTAL, 10, 1, 2
        );
        BiomeModifications.addSpawn(
                BiomeSelectors.tag(ConventionalBiomeTags.IS_SNOWY_PLAINS),
                class_1311.field_6302,
                RDEntityTypes.ICE_ELEMENTAL, 10, 1, 2
        );
        BiomeModifications.addSpawn(
                BiomeSelectors.tag(ConventionalBiomeTags.IS_COLD_END),
                class_1311.field_6302,
                RDEntityTypes.ICE_ELEMENTAL, 10, 1, 2
        );
        class_1317.method_20637(
                RDEntityTypes.ICE_ELEMENTAL,
                class_9169.field_48745,
                class_2902.class_2903.field_13203,
                IceElementalEntity::canSpawn
        );
        // 月兔
        BiomeModifications.addSpawn(
                BiomeSelectors.includeByKey(BiomeInit.THE_MOON),
                class_1311.field_6302,
                RDEntityTypes.MOON_RABBIT, 10, 1, 1
        );
        BiomeModifications.create(class_2960.method_60655("reverie_dreams", "moon_spawns"))
                .add(ModificationPhase.ADDITIONS,
                        BiomeSelectors.includeByKey(BiomeInit.THE_MOON),
                        ctx -> ctx.getSpawnSettings().addSpawn(
                                class_1311.field_6302,
                                new class_5483.class_1964(RDEntityTypes.MOON_RABBIT, 1, 1),
                                5
                        )
                );
        // UFO
        BiomeModifications.addSpawn(
                BiomeSelectors.tag(ConventionalBiomeTags.IS_MOUNTAIN_PEAK),
                class_1311.field_6302,
                RDEntityTypes.UFO, 3, 1, 2
        );

//        SpawnRestriction.register(
//                ModEntities.MOON_RABBIT,
//                SpawnLocationTypes.ON_GROUND,
//                Heightmap.Type.MOTION_BLOCKING_NO_LEAVES,
//                (entity, world, reason, pos, random) -> {
//                    return world.getBlockState(pos.up()).isAir();
//                }
//        );
//        SpawnRestriction.register(
//                ModEntities.MOON_RABBIT,
//                SpawnLocationTypes.ON_GROUND,
//                Heightmap.Type.MOTION_BLOCKING_NO_LEAVES,
//                (entity, world, reason, pos, random) ->
//                        world.getBlockState(pos.down()).isOf(ModBlocks.MOON_STONE.block()) &&
//                                world.getBlockState(pos).isAir()
//        );
    }

    public static void addStructure() {
//        BiomeModifications.addFeature(
//                biome -> biome.getBiomeKey() == BiomeKeys.FOREST,
//                GenerationStep.Feature.SURFACE_STRUCTURES,
//
//                );
    }

    public static boolean canSpawn(class_1299<?> type, class_3218 world, class_3730 reason, class_2338 pos, Random random) {
        return world.method_22339(pos) <= 7 && world.method_8320(pos.method_10074()).method_26212(world, pos.method_10074());
    }

}
