package cc.thonly.reverie_dreams.world.gen;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.block.base.FruitLeavesBlock;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.registry.content.block.RDWoodBlocks;
import cc.thonly.reverie_dreams.world.gen.feature.*;
import net.minecraft.class_1299;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_3124;
import net.minecraft.class_3175;
import net.minecraft.class_3481;
import net.minecraft.class_3798;
import net.minecraft.class_3819;
import net.minecraft.class_3825;
import net.minecraft.class_4638;
import net.minecraft.class_4643;
import net.minecraft.class_4646;
import net.minecraft.class_4651;
import net.minecraft.class_4657;
import net.minecraft.class_5140;
import net.minecraft.class_5204;
import net.minecraft.class_5321;
import net.minecraft.class_5930;
import net.minecraft.class_6012;
import net.minecraft.class_6016;
import net.minecraft.class_6019;
import net.minecraft.class_6817;
import net.minecraft.class_7891;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.world.level.levelgen.feature.configurations.*;
import java.util.List;

public class ConfigurationFeatureInit {
    // 主世界
    public static final class_5321<class_2975<?, ?>> SPIRITUAL_TREE_KEY = getOrCreateRegistryKey("spiritual_tree");
    public static final class_5321<class_2975<?, ?>> LEMON_TREE_KEY = getOrCreateRegistryKey("lemon_tree");
    public static final class_5321<class_2975<?, ?>> GINKGO_TREE_KEY = getOrCreateRegistryKey("ginkgo_tree");
    public static final class_5321<class_2975<?, ?>> PEACH_TREE_KEY = getOrCreateRegistryKey("peach_tree");
    public static final class_5321<class_2975<?, ?>> OVERWORLD_SILVER_ORE_KEY = getOrCreateRegistryKey("overworld_silver_ore");
    public static final class_5321<class_2975<?, ?>> OVERWORLD_ORB_ORE_KEY = getOrCreateRegistryKey("overworld_orb_ore");
    public static final class_5321<class_2975<?, ?>> NETHER_BLACK_SALT_ORE_KEY = getOrCreateRegistryKey("nether_black_salt");
    public static final class_5321<class_2975<?, ?>> UDUMBARA_FLOWER_KEY = getOrCreateRegistryKey("udumbara_flower");
    public static final class_5321<class_2975<?, ?>> TREMELLA_KEY = getOrCreateRegistryKey("tremella_flower");

    // 月球
    public static final class_5321<class_2975<?, ?>> CRATER_KEY = getOrCreateRegistryKey("crater");
    public static final class_5321<class_2975<?, ?>> DREAM_WORLD_GRID = getOrCreateRegistryKey("dream_world_grid");
    public static final class_5321<class_2975<?, ?>> CRATER_MEGA_KEY = getOrCreateRegistryKey("crater_mega");
    public static final class_5321<class_2975<?, ?>> CRATER_LARGE_KEY = getOrCreateRegistryKey("crater_large");
    public static final class_5321<class_2975<?, ?>> CRATER_SMALL_KEY = getOrCreateRegistryKey("crater_small");
    public static final class_5321<class_2975<?, ?>> DREAM_GRID_KEY = getOrCreateRegistryKey("dream_world_grid");
    public static final class_5321<class_2975<?, ?>> FLOATING_DREAM_STONE_KEY = getOrCreateRegistryKey("floating_dream_stone");
    public static final class_5321<class_2975<?, ?>> FLOATING_DREAM_CRYSTAL_KEY = getOrCreateRegistryKey("floating_dream_crystal");
    public static final class_5321<class_2975<?, ?>> FLOATING_DREAM_TRIAL_ROOM_ZOMBIE_KEY = getOrCreateRegistryKey("float_dream_trial_room_zombie");
    public static final class_5321<class_2975<?, ?>> FLOATING_DREAM_TRIAL_ROOM_SKELETON_KEY = getOrCreateRegistryKey("float_dream_trial_room_skeleton");
    public static final class_5321<class_2975<?, ?>> DREAM_FLOATING_ISLAND_KEY = getOrCreateRegistryKey("dream_floating_island");

    // 梦境世界
    public static final class_3031<CraterFeatureConfig> CRATER = register("crater", new CraterFeature(CraterFeatureConfig.CODEC));
    public static final class_3031<DreamGridFeatureConfig> DREAM_GRID = register("dream_world_grid", new DreamGridFeature(DreamGridFeatureConfig.CODEC));
    public static final class_3031<DreamTrialRoomConfig> DREAM_TRIAL_ROOM = register("dream_trial_room", new DreamTrialRoom(DreamTrialRoomConfig.CODEC));
    public static final class_3031<FloatingSphereFeatureConfig> FLOATING_SPHERE = register("floating_sphere", new FloatingSphereFeature(FloatingSphereFeatureConfig.CODEC));
    public static final class_3031<class_3111> DREAM_FLOATING_ISLAND = register("dream_floating_island", new FloatingIslandFeature(class_3111.field_24893));

    // 主世界结构


    public static void init() {

    }

    public static void bootstrap(class_7891<class_2975<?, ?>> context) {
        class_3825 stoneReplaceables = new class_3798(class_3481.field_28992);
        class_3825 deepslateReplaceables = new class_3798(class_3481.field_28993);
        class_3825 netherOreReplaceables = new class_3798(class_3481.field_38833);
        class_3825 endOreReplaceables = new class_3819(class_2246.field_10471);

        List<class_3124.class_5876> overworldSilverTargets = List.of(
                class_3124.method_33994(stoneReplaceables, RDBlocks.SILVER_ORE.method_9564()),
                class_3124.method_33994(deepslateReplaceables, RDBlocks.DEEPSLATE_SILVER_ORE.method_9564()));
        List<class_3124.class_5876> overworldOrbTargets = List.of(
                class_3124.method_33994(stoneReplaceables, RDBlocks.ORB_ORE.method_9564()),
                class_3124.method_33994(deepslateReplaceables, RDBlocks.DEEPSLATE_ORB_ORE.method_9564()));
        List<class_3124.class_5876> netherSaltTargets = List.of(
                class_3124.method_33994(netherOreReplaceables, RDBlocks.BLACK_SALT_BLOCK.method_9564())
        );

        // 树木
        context.method_46838(SPIRITUAL_TREE_KEY, new class_2975<>(class_3031.field_24134,
                new class_4643.class_4644(
                        class_4651.method_38432(RDWoodBlocks.SPIRITUAL.log()),
                        new class_5140(4, 2, 1),
                        class_4651.method_38432(RDWoodBlocks.SPIRITUAL.leaves()),
                        new class_4646(class_6016.method_34998(4), class_6016.method_34998(2), 2),
                        new class_5204(1, 0, 2)
                ).method_23445()
        ));

        context.method_46838(LEMON_TREE_KEY, new class_2975<>(class_3031.field_24134,
                new class_4643.class_4644(
                        class_4651.method_38432(RDWoodBlocks.LEMON.log()),
                        new class_5930(2, 1, 2, 2, class_6019.method_35017(1, 1)),
                        new class_4657(class_6012.<class_2680>method_66215()
                                .method_34975(RDWoodBlocks.LEMON.leaves().method_9564().method_11657(class_2397.field_11200, true).method_11657(class_2397.field_38227, false), 3)
                                .method_34975(RDWoodBlocks.LEMON_FRUIT_LEAVES.method_9564().method_11657(class_2397.field_11200, true).method_11657(FruitLeavesBlock.AGE_PROPERTY, FruitLeavesBlock.MAX_AGE).method_11657(class_2397.field_38227, false), 1)),
                        new class_4646(class_6016.method_34998(3), class_6016.method_34998(2), 2),
                        new class_5204(1, 0, 2)
                ).method_23445()
        ));

        context.method_46838(GINKGO_TREE_KEY, new class_2975<>(class_3031.field_24134,
                new class_4643.class_4644(
                        class_4651.method_38432(RDWoodBlocks.LEMON.log()),
                        new class_5140(3, 1, 0),
                        new class_4657(class_6012.<class_2680>method_66215()
                                .method_34975(RDWoodBlocks.GINKGO.leaves().method_9564().method_11657(class_2397.field_11200, true).method_11657(class_2397.field_38227, false), 3)
                                .method_34975(RDWoodBlocks.GINKGO_FRUIT_LEAVES.method_9564().method_11657(class_2397.field_11200, true).method_11657(FruitLeavesBlock.AGE_PROPERTY, FruitLeavesBlock.MAX_AGE).method_11657(class_2397.field_38227, false), 1)),
                        new class_4646(class_6016.method_34998(3), class_6016.method_34998(2), 2),
                        new class_5204(1, 0, 2)
                ).method_23445()
        ));

        context.method_46838(PEACH_TREE_KEY, new class_2975<>(class_3031.field_24134,
                new class_4643.class_4644(
                        class_4651.method_38432(RDWoodBlocks.PEACH.log()),
                        new class_5140(2, 1, 1),
                        new class_4657(class_6012.<class_2680>method_66215()
                                .method_34975(RDWoodBlocks.PEACH.leaves().method_9564().method_11657(class_2397.field_11200, true).method_11657(class_2397.field_38227, false), 3)
                                .method_34975(RDWoodBlocks.PEACH_FRUIT_LEAVES.method_9564().method_11657(class_2397.field_11200, true).method_11657(FruitLeavesBlock.AGE_PROPERTY, FruitLeavesBlock.MAX_AGE).method_11657(class_2397.field_38227, false), 1)),
                        new class_4646(class_6016.method_34998(3), class_6016.method_34998(2), 2),
                        new class_5204(1, 0, 2)
                ).method_23445()
        ));

        // 矿物
        context.method_46838(OVERWORLD_SILVER_ORE_KEY, new class_2975<>(class_3031.field_13517,
                new class_3124(overworldSilverTargets, 15, 0.3F)
        ));

        context.method_46838(OVERWORLD_ORB_ORE_KEY, new class_2975<>(class_3031.field_13517,
                new class_3124(overworldOrbTargets, 7, 0.32F)
        ));

        context.method_46838(NETHER_BLACK_SALT_ORE_KEY, new class_2975<>(class_3031.field_13517,
                new class_3124(netherSaltTargets, 7, 0.22F)
        ));

        // 花
        context.method_46838(UDUMBARA_FLOWER_KEY, new class_2975<>(class_3031.field_21219,
                new class_4638(32, 4, 1,
                        class_6817.method_40366(class_3031.field_13518,
                                new class_3175(class_4651.method_38432(RDWoodBlocks.UDUMBARA_FLOWER)))
                )
        ));
        context.method_46838(TREMELLA_KEY, new class_2975<>(class_3031.field_21219,
                new class_4638(32, 5, 2,
                        class_6817.method_40366(class_3031.field_13518,
                                new class_3175(class_4651.method_38432(RDWoodBlocks.TREMELLA)))
                )
        ));

        // 世界生成
        context.method_46838(CRATER_SMALL_KEY, new class_2975<>(
                CRATER,
                new CraterFeatureConfig(
                        class_6019.method_35017(2, 3),
                        class_6019.method_35017(4, 7)
                )
        ));
        context.method_46838(CRATER_LARGE_KEY, new class_2975<>(
                CRATER,
                new CraterFeatureConfig(
                        class_6019.method_35017(3, 5),
                        class_6019.method_35017(12, 15)
                )
        ));
        context.method_46838(CRATER_MEGA_KEY, new class_2975<>(
                CRATER,
                new CraterFeatureConfig(
                        class_6019.method_35017(8, 16),
                        class_6019.method_35017(32, 48)
                )
        ));

        context.method_46838(DREAM_GRID_KEY, new class_2975<>(DREAM_GRID,
                new DreamGridFeatureConfig(class_7923.field_41175.method_10221(class_2246.field_10540))
        ));

        context.method_46838(FLOATING_DREAM_STONE_KEY, new class_2975<>(FLOATING_SPHERE,
                new FloatingSphereFeatureConfig(class_7923.field_41175.method_10221(RDBlocks.DREAM_STONE.block()), 2, 7, 25, 120, 32)
        ));

        context.method_46838(FLOATING_DREAM_CRYSTAL_KEY, new class_2975<>(FLOATING_SPHERE,
                new FloatingSphereFeatureConfig(class_7923.field_41175.method_10221(RDBlocks.DREAM_CRYSTAL_ORE), 0, 1, 60, 128, 32)
        ));

        context.method_46838(FLOATING_DREAM_TRIAL_ROOM_ZOMBIE_KEY, new class_2975<>(DREAM_TRIAL_ROOM,
                new DreamTrialRoomConfig(class_7923.field_41177.method_10221(class_1299.field_6051))
        ));
        context.method_46838(FLOATING_DREAM_TRIAL_ROOM_SKELETON_KEY, new class_2975<>(DREAM_TRIAL_ROOM,
                new DreamTrialRoomConfig(class_7923.field_41177.method_10221(class_1299.field_6137))
        ));

        context.method_46838(DREAM_FLOATING_ISLAND_KEY, new class_2975<>(DREAM_FLOATING_ISLAND,
                new class_3111()
        ));

    }

    private static class_5321<class_2975<?, ?>> getOrCreateRegistryKey(String name) {
        return class_5321.method_29179(class_7924.field_41239, ReverieDreams.id(name));
    }

    private static <C extends class_3037, F extends class_3031<C>> F registerForVanilla(String name, F feature) {
        return (F) class_2378.method_10226(class_7923.field_41144, name, feature);
    }

    private static <C extends class_3037, F extends class_3031<C>> F register(String name, F feature) {
        return (F) class_2378.method_10230(class_7923.field_41144, ReverieDreams.id(name), feature);
    }
}
