package cc.thonly.reverie_dreams.world.gen.feature;

import cc.thonly.reverie_dreams.registry.content.block.RDWoodBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class FloatingIslandFeature extends class_3031<class_3111> {
    public FloatingIslandFeature(Codec<class_3111> codec) {
        super(codec);
    }

    @Override
    public boolean method_13151(class_5821<class_3111> ctx) {
        class_1936 world = ctx.method_33652();
        // 顶面海拔：100~160
        class_2338 topPlane = ctx.method_33655().method_10086(100 + world.method_8409().method_43048(60));

        // 生成几个“半椭球”并叠加，顶面统一用同一平面（oy = 0 保证平顶）
        for (int i = 0; i < 5; i++) {
            int rx = 8 + world.method_8409().method_43048(6);
            int ry = 4 + world.method_8409().method_43048(3);
            int rz = 8 + world.method_8409().method_43048(6);

            int ox = world.method_8409().method_43048(6) - 3;
            int oz = world.method_8409().method_43048(6) - 3;

            // 顶面中心位置（同一个水平面）
            class_2338 lobeTopCenter = topPlane.method_10069(ox, 0, oz);
            generateHemisphereDownFlatTop(world, lobeTopCenter, rx, ry, rz);
            decorateTop(world, lobeTopCenter, rx, rz, world.method_8409());
        }
        return true;
    }

    private void sprinkleGrass(class_1936 world, class_2338 topCenter, int rx, int rz, class_5819 random) {
        for (int x = -rx; x <= rx; x++) {
            for (int z = -rz; z <= rz; z++) {
                if (random.method_43057() < 0.1f) { // 20% 概率额外放草
                    class_2338 pos = topCenter.method_10069(x, 0, z);
                    if (world.method_8320(pos).method_27852(class_2246.field_10219) && world.method_22347(pos.method_10084())) {
                        world.method_8652(pos.method_10084(), class_2246.field_10214.method_9564(), 3);
                    }
                }
            }
        }
    }


    private void decorateTop(class_1936 world, class_2338 topCenter, int rx, int rz, class_5819 random) {
        int decorations = 5 + random.method_43048(8); // 每个岛 5~12 个装饰
        int saplingCount = 0; // 限制树苗数量

        for (int i = 0; i < decorations; i++) {
            int x = random.method_43048(rx * 2 + 1) - rx;
            int z = random.method_43048(rz * 2 + 1) - rz;
            class_2338 pos = topCenter.method_10069(x, 0, z);
            if (!world.method_8320(pos).method_27852(class_2246.field_10219)) continue;
            class_2338 above = pos.method_10084();
            if (!world.method_22347(above)) continue;

            int roll = random.method_43048(4);
            switch (roll) {
                case 0 -> {
                }
                case 1 -> {
                    world.method_8652(above,
                            random.method_43056() ? RDWoodBlocks.UDUMBARA_FLOWER.method_9564() : class_2246.field_10449.method_9564(), 3);
                }
                case 2 -> {
                    if (saplingCount < 2) {
                        world.method_8652(above, class_2246.field_10394.method_9564(), 3);
                        saplingCount++;
                    }
                }
                case 3 -> {
                    // 小水塘（2×2 或 3×3）
                    int size = random.method_43056() ? 2 : 3;
                    for (int dx = 0; dx < size; dx++) {
                        for (int dz = 0; dz < size; dz++) {
                            class_2338 pondPos = pos.method_10069(dx, 0, dz);
                            if (world.method_8320(pondPos).method_27852(class_2246.field_10219)) {
                                world.method_8652(pondPos, class_2246.field_10382.method_9564(), 3);
                            }
                        }
                    }
                }
            }
        }
        sprinkleGrass(world, topCenter, rx, rz, random);
    }



    /**
     * 以 topCenter 为顶面中心（y=0），向“下方”生成半椭球。
     * 顶面整片为草；往下 2 层为泥土；更下为石头。
     */
    private void generateHemisphereDownFlatTop(class_1936 world, class_2338 topCenter, int rx, int ry, int rz) {
        // 遍历顶面投影的椭圆盘
        for (int x = -rx; x <= rx; x++) {
            for (int z = -rz; z <= rz; z++) {
                // 先判断 (x,z) 是否落在椭圆投影内： (x/rx)^2 + (z/rz)^2 <= 1
                double proj = (x * x) / (double) (rx * rx) + (z * z) / (double) (rz * rz);
                if (proj > 1.0) continue;

                // 该 (x,z) 方向上半椭球的最大“深度”（向下的 y 范围）
                // 椭球方程：x^2/rx^2 + y^2/ry^2 + z^2/rz^2 <= 1
                // 给定 x,z，得到 |y| <= ry * sqrt(1 - proj)
                int maxDepth = (int) Math.floor(ry * Math.sqrt(1.0 - proj));
                if (maxDepth <= 0) continue;

                // 从顶面 y=0 向下铺到 y = -maxDepth
                for (int dy = 0; dy >= -maxDepth; dy--) {
                    class_2338 pos = topCenter.method_10069(x, dy, z);

                    if (dy == 0) {
                        // 顶面：整片草；如果你想避免覆盖已有方块，可先判断 isAir
                        world.method_8652(pos, class_2246.field_10219.method_9564(), 3);
                    } else if (dy >= -2) {
                        world.method_8652(pos, class_2246.field_10566.method_9564(), 3);
                    } else {
                        world.method_8652(pos, class_2246.field_10340.method_9564(), 3);
                    }
                }
            }
        }
    }
}
