package nota.player;

import net.minecraft.class_1657;
import net.minecraft.class_2338;
import nota.Nota;
import nota.model.Layer;
import nota.model.Note;
import nota.model.Playlist;
import nota.model.Song;

/**
 * SongPlayer playing to everyone added to it no matter where they are
 */
public class RadioSongPlayer extends SongPlayer {

	public RadioSongPlayer(Song song) {
		super(song);
	}

	public RadioSongPlayer(Playlist playlist) {
		super(playlist);
	}

	@Override
	public void playTick(class_1657 player, int tick) {
		byte playerVolume = Nota.getPlayerVolume(player);

		for(Layer layer : song.getLayerHashMap().values()) {
			Note note = layer.getNote(tick);
			if(note == null) {
				continue;
			}

			float volume = (layer.getVolume() * (int) this.volume * (int) playerVolume * note.getVelocity()) / 100_00_00_00F;
			var eyePos = player.method_33571();
			channelMode.play(player, new class_2338((int) eyePos.method_10216(), (int) eyePos.method_10214(), (int) eyePos.method_10215()), song, layer, note, volume, !enable10Octave);
		}
	}
}
