/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.data.danmaku;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class Pattern {
    private final List<String> patternString;

    public Pattern(List<String> patternString) {
        this.patternString = patternString;
    }

    public List<String> getPatternString() {
        return new LinkedList<String>(this.patternString);
    }

    public char[][] getChars() {
        List<String> lines = this.getPatternString();
        if (lines.isEmpty()) {
            return new char[0][0];
        }
        int height = lines.size();
        int width = lines.stream().mapToInt(String::length).max().orElse(0);
        char[][] chars = new char[height][width];
        for (int y = 0; y < height; ++y) {
            String line = lines.get(y);
            for (int x = 0; x < width; ++x) {
                chars[y][x] = x < line.length() ? (int)line.charAt(x) : 32;
            }
        }
        return chars;
    }

    public static Pattern of(String[] strings) {
        return new Pattern(Arrays.stream(strings).toList());
    }

    public static Pattern of(String string) {
        return new Pattern(List.of(string));
    }

    public static class BuiltIn {
        public static final Pattern STAR = Pattern.of(new String[]{"##   ##", " ## ## ", " # # # ", "##   ##", "  # #  ", "   #   "});
        public static final Pattern HEART = Pattern.of(new String[]{"   #   ", "  # #  ", " # # # ", "# # # #", " #   # "});
        public static final Pattern X = Pattern.of(new String[]{"#   #", " # # ", "  #  ", " # # ", "#   #"});
    }
}

