/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.datagen.generator;

import cc.thonly.reverie_dreams.data.FoodProperty;
import cc.thonly.reverie_dreams.datagen.generator.DataGeneratorUtil;
import com.google.common.hash.HashCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIngredientProvider
implements class_2405 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractIngredientProvider.class);
    public final FabricDataOutput output;
    public final CompletableFuture<class_7225.class_7874> future;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<class_2960, Factory> identifier2BuilderListMap = new Object2ObjectOpenHashMap();

    public AbstractIngredientProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> future) {
        this.output = output;
        this.future = future;
        this.configured();
    }

    public Factory createFactory(FoodProperty property) {
        class_2960 id = property.getId();
        if (this.identifier2BuilderListMap.containsKey(id)) {
            return this.identifier2BuilderListMap.get(id);
        }
        Factory factory = new Factory(id, property);
        this.identifier2BuilderListMap.put(id, factory);
        return factory;
    }

    public Factory createFactory(FoodProperty property, class_1792 ... items) {
        Factory factory = this.createFactory(property);
        factory.getList().addAll(Arrays.stream(items).toList());
        return factory;
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return CompletableFuture.runAsync(() -> {
            this.configured();
            this.export(writer);
        });
    }

    protected abstract void configured();

    public void export(class_7403 writer) {
        Path path = Paths.get(DataGeneratorUtil.OUTPUT_DIR, new String[0]);
        try {
            for (Map.Entry<class_2960, Factory> entry : this.identifier2BuilderListMap.entrySet()) {
                class_2960 identifier = entry.getKey();
                Factory factory = entry.getValue();
                factory.getProperty().setId(identifier);
                Path generatePath = DataGeneratorUtil.getData(path, "reverie_dreams", "food_property", null);
                DataResult result = FoodProperty.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)factory.getProperty());
                Optional optional = result.result();
                if (!optional.isPresent()) continue;
                JsonElement element = (JsonElement)optional.get();
                Path output = generatePath.resolve(identifier.method_12832() + ".json");
                String jsonString = this.gson.toJson(element);
                byte[] bytes = jsonString.getBytes(StandardCharsets.UTF_8);
                Files.createDirectories(output.getParent(), new FileAttribute[0]);
                writer.method_43346(output, bytes, HashCode.fromBytes((byte[])bytes));
            }
        }
        catch (Exception err) {
            log.error("Error: ", (Throwable)err);
        }
    }

    public static class Factory {
        private final class_2960 id;
        private final FoodProperty property;
        private final List<class_1792> list = new LinkedList<class_1792>();
        private boolean done = false;

        protected Factory(class_2960 id, FoodProperty property) {
            this.id = id;
            this.property = property;
        }

        public Factory add(class_1792 item) {
            this.list.add(item);
            return this;
        }

        public Factory add(class_1792 ... item) {
            this.list.addAll(Arrays.stream(item).toList());
            return this;
        }

        public void build() {
            this.property.getItems().addAll(this.list);
            this.done = true;
        }

        @Generated
        public void setDone(boolean done) {
            this.done = done;
        }

        @Generated
        public class_2960 getId() {
            return this.id;
        }

        @Generated
        public FoodProperty getProperty() {
            return this.property;
        }

        @Generated
        public List<class_1792> getList() {
            return this.list;
        }

        @Generated
        public boolean isDone() {
            return this.done;
        }
    }
}

