/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.datagen.generator;

import cc.thonly.reverie_dreams.datagen.generator.DataGeneratorUtil;
import com.google.common.hash.HashCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7924;
import net.minecraft.class_9793;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJukeboxProvider
implements class_2405 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractJukeboxProvider.class);
    public final FabricDataOutput output;
    public final CompletableFuture<class_7225.class_7874> future;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<class_2960, class_9793> identifierJukeboxSongMap = new Object2ObjectOpenHashMap();

    public AbstractJukeboxProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> future) {
        this.output = output;
        this.future = future;
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return CompletableFuture.runAsync(() -> {
            this.configured();
            this.export(writer);
        });
    }

    public class_9793 add(class_2960 id, class_9793 song) {
        return this.identifierJukeboxSongMap.put(id, song);
    }

    public abstract void configured();

    public void export(class_7403 writer) {
        try {
            Path path = Paths.get(DataGeneratorUtil.OUTPUT_DIR, new String[0]);
            for (Map.Entry<class_2960, class_9793> entry : this.identifierJukeboxSongMap.entrySet()) {
                String namespace = entry.getKey().method_12836();
                String key = entry.getKey().method_12832();
                class_9793 ref = entry.getValue();
                Path generatePath = DataGeneratorUtil.getData(path, namespace, class_7924.field_52176, null);
                DataResult result = class_9793.field_52027.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ref);
                Optional optional = result.result();
                if (!optional.isPresent()) continue;
                JsonElement element = (JsonElement)optional.get();
                Path output = generatePath.resolve(key + ".json");
                String jsonString = this.gson.toJson(element);
                byte[] bytes = jsonString.getBytes(StandardCharsets.UTF_8);
                Files.createDirectories(output.getParent(), new FileAttribute[0]);
                writer.method_43346(output, bytes, HashCode.fromBytes((byte[])bytes));
            }
        }
        catch (Exception err) {
            log.error("Error: ", (Throwable)err);
        }
    }

    public String method_10321() {
        return "Jukebox Song JSON Provider";
    }
}

