/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.entity.ai.goal.work;

import cc.thonly.reverie_dreams.entity.ai.goal.util.EntityTargetUtil;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.inventory.NPCInventoryImpl;
import cc.thonly.reverie_dreams.registry.content.NPCWorkModes;
import cc.thonly.reverie_dreams.server.ItemCateManager;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_3341;
import net.minecraft.class_3417;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class NPCChestClassificationGoal
extends class_1352 {
    private final BaseNPCLikeEntity roleEntity;
    @Nullable
    private OperationalTarget currentTarget = null;

    public NPCChestClassificationGoal(BaseNPCLikeEntity roleEntity) {
        this.roleEntity = roleEntity;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    private List<class_2338> findChestBlockPosList() {
        LinkedList<class_2338> list = new LinkedList<class_2338>();
        class_1937 world = this.roleEntity.method_37908();
        class_2338 center = this.roleEntity.getWorkingPos();
        int r = 8;
        class_3341 box = new class_3341(center.method_10263() - r, center.method_10264() - r, center.method_10260() - r, center.method_10263() + r, center.method_10264() + r, center.method_10260() + r);
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = box.method_35415(); x <= box.method_35418(); ++x) {
            for (int y = box.method_35416(); y <= box.method_35419(); ++y) {
                for (int z = box.method_35417(); z <= box.method_35420(); ++z) {
                    pos.method_10103(x, y, z);
                    if (world.method_8320((class_2338)pos).method_26204() != class_2246.field_10034 || !(world.method_8321((class_2338)pos) instanceof class_2595)) continue;
                    list.add(pos.method_10062());
                }
            }
        }
        list.sort((a, b) -> Double.compare(a.method_10262((class_2382)center), b.method_10262((class_2382)center)));
        if (!list.isEmpty()) {
            // empty if block
        }
        return list;
    }

    public boolean method_6264() {
        boolean can = EntityTargetUtil.isThisWorkMode(this.roleEntity, NPCWorkModes.CHEST_CLASSIFICATION);
        MinecraftServer server = this.roleEntity.method_5682();
        if (server != null && ItemCateManager.getInstance().isEmpty()) {
            ItemCateManager.getInstance().load(server);
        }
        return can;
    }

    public boolean method_6266() {
        boolean cont = EntityTargetUtil.isThisWorkMode(this.roleEntity, NPCWorkModes.CHEST_CLASSIFICATION);
        return cont;
    }

    public boolean method_38846() {
        return true;
    }

    private OperationalTarget findNextTarget(NPCInventoryImpl inventory) {
        List<class_2338> chests = this.findChestBlockPosList();
        for (int invIndex = 0; invIndex < inventory.method_5439(); ++invIndex) {
            class_1799 held = inventory.method_5438(invIndex);
            if (held.method_7960()) continue;
            for (class_2338 chestPos : chests) {
                class_2586 be = this.roleEntity.method_37908().method_8321(chestPos);
                if (!(be instanceof class_2595)) continue;
                class_2595 chest = (class_2595)be;
                boolean chestEmpty = true;
                boolean chestCompatible = true;
                for (int s = 0; s < chest.method_5439(); ++s) {
                    class_1799 cs = chest.method_5438(s);
                    if (cs.method_7960()) continue;
                    chestEmpty = false;
                    if (class_1799.method_31577((class_1799)cs, (class_1799)held)) continue;
                    chestCompatible = false;
                    break;
                }
                if (!chestCompatible) continue;
                for (int slot = 0; slot < chest.method_5439(); ++slot) {
                    int space;
                    class_1799 chestStack = chest.method_5438(slot);
                    if (chestStack.method_7960()) {
                        return new OperationalTarget(invIndex, chestPos, chest, slot);
                    }
                    if (!class_1799.method_31577((class_1799)chestStack, (class_1799)held) || (space = chestStack.method_7914() - chestStack.method_7947()) <= 0) continue;
                    return new OperationalTarget(invIndex, chestPos, chest, slot);
                }
            }
        }
        return null;
    }

    public void method_6268() {
        class_1799 held;
        NPCInventoryImpl inventory = this.roleEntity.getInventory();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
        }
        if (this.currentTarget == null) {
            this.currentTarget = this.findNextTarget(inventory);
            if (this.currentTarget == null) {
                return;
            }
        }
        if ((held = inventory.method_5438(this.currentTarget.inventorySlot)).method_7960()) {
            this.currentTarget = null;
            return;
        }
        if (!this.isReached(this.currentTarget.blockPos)) {
            this.roleEntity.method_5942().method_6337((double)this.currentTarget.blockPos.method_10263() + 0.5, (double)this.currentTarget.blockPos.method_10264() + 0.5, (double)this.currentTarget.blockPos.method_10260() + 0.5, 1.0);
            return;
        }
        class_2595 chest = this.currentTarget.chest;
        int slotIndex = this.currentTarget.slotIndex;
        class_1799 chestStack = chest.method_5438(slotIndex);
        boolean slotSuitable = false;
        if (chestStack.method_7960()) {
            slotSuitable = true;
        } else if (class_1799.method_31577((class_1799)chestStack, (class_1799)held) && chestStack.method_7947() < chestStack.method_7914()) {
            slotSuitable = true;
        }
        if (!slotSuitable) {
            Integer nextSlot = this.findNextSlotInSameChest(chest, held);
            if (nextSlot != null) {
                this.currentTarget = new OperationalTarget(this.currentTarget.inventorySlot, this.currentTarget.blockPos, chest, nextSlot);
                slotIndex = nextSlot;
                chestStack = chest.method_5438(slotIndex);
            } else {
                this.currentTarget = null;
                return;
            }
        }
        chestStack = chest.method_5438(slotIndex);
        held = inventory.method_5438(this.currentTarget.inventorySlot);
        if (held.method_7960()) {
            this.currentTarget = null;
            return;
        }
        if (chestStack.method_7960()) {
            int move = Math.min(held.method_7947(), held.method_7914());
            class_1799 toSet = held.method_7972();
            toSet.method_7939(move);
            chest.method_5447(slotIndex, toSet);
            held.method_7934(move);
        } else {
            int space = chestStack.method_7914() - chestStack.method_7947();
            int move = Math.min(space, held.method_7947());
            if (move > 0) {
                chestStack.method_7933(move);
                held.method_7934(move);
            } else {
                this.currentTarget = null;
                return;
            }
        }
        chest.method_5431();
        this.roleEntity.method_6104(class_1268.field_5808);
        this.roleEntity.method_56078(class_3417.field_14982);
        if (inventory.method_5438(this.currentTarget.inventorySlot).method_7960()) {
            this.currentTarget = null;
        }
    }

    private Integer findNextSlotInSameChest(class_2595 chest, class_1799 held) {
        for (int s = 0; s < chest.method_5439(); ++s) {
            class_1799 cs = chest.method_5438(s);
            if (cs.method_7960()) {
                return s;
            }
            if (!class_1799.method_31577((class_1799)cs, (class_1799)held) || cs.method_7947() >= cs.method_7914()) continue;
            return s;
        }
        return null;
    }

    private boolean isReached(class_2338 pos) {
        return pos.method_19770((class_2374)this.roleEntity.method_19538()) <= 9.0;
    }

    private record OperationalTarget(int inventorySlot, class_2338 blockPos, class_2595 chest, int slotIndex) {
    }
}

