/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.gui;

import cc.thonly.reverie_dreams.gui.recipe.GuiOpeningPrevCallback;
import cc.thonly.reverie_dreams.gui.recipe.GuiStackBuilder;
import cc.thonly.reverie_dreams.gui.recipe.RecipeTypeGuiInfo;
import cc.thonly.reverie_dreams.gui.recipe.RecipeTypeInfo;
import cc.thonly.reverie_dreams.recipe.view.RecipeEntryWrapper;
import cc.thonly.reverie_dreams.registry.content.item.RDGuiItems;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_1713;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;

public class BasePageGui
extends SimpleGui {
    public static final String[][] GRID = new String[][]{{"X", "X", "X", "X", "X", "X", "X", "X", "X"}, {"X", "X", "X", "X", "X", "X", "X", "X", "X"}, {"X", "X", "X", "X", "X", "X", "X", "X", "X"}, {"X", "X", "X", "X", "X", "X", "X", "X", "X"}, {"X", "X", "X", "X", "X", "X", "X", "X", "X"}, {"P", "W", "W", "W", "B", "W", "W", "W", "N"}};
    public static final int PER_PAGE_SIZE = 45;
    public final GuiElementBuilder back = new GuiElementBuilder(RDGuiItems.BACK).setItemName(class_2561.method_30163((String)"Back")).setCallback(this::back);
    public final GuiElementBuilder next = new GuiElementBuilder(RDGuiItems.NEXT).setItemName(class_2561.method_30163((String)"Next Page")).setCallback(this::next);
    public final GuiElementBuilder prev = new GuiElementBuilder(RDGuiItems.PREV).setItemName(class_2561.method_30163((String)"Prev Page")).setCallback(this::prev);
    public int page = 0;
    public final int maxSize;
    public final List<GuiElementBuilder> displayList = new LinkedList<GuiElementBuilder>();
    public final RecipeTypeGuiInfo<? extends BasePageGui> recipeGuiInfo;
    public final RecipeTypeInfo recipeTypeInfo;
    public final List<RecipeEntryWrapper<?>> entries;
    public boolean updated = true;
    public GuiOpeningPrevCallback prevGuiCallback;

    public BasePageGui(class_3222 player, RecipeTypeGuiInfo<? extends BasePageGui> recipeGuiInfo, RecipeTypeInfo recipeTypeInfo, GuiOpeningPrevCallback prevGuiCallback) {
        super(class_3917.field_17327, player, false);
        this.recipeGuiInfo = recipeGuiInfo;
        this.recipeTypeInfo = recipeTypeInfo;
        this.entries = new LinkedList();
        Map<class_2960, ?> registryView = this.recipeTypeInfo.getRecipeType().getRegistryView();
        for (Map.Entry<class_2960, ?> entry : registryView.entrySet()) {
            this.entries.add(new RecipeEntryWrapper(entry.getKey(), entry.getValue()));
        }
        this.maxSize = this.entries.size();
        this.prevGuiCallback = prevGuiCallback;
        this.init();
        this.setTitle((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)this.recipeGuiInfo.getId().method_42094())).method_10852(class_2561.method_30163((String)(" (" + (this.page + 1) + "/" + (this.getMaxPage() + 1) + ")"))));
    }

    public void init() {
        this.setTitle((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)this.recipeGuiInfo.getId().method_42094())).method_10852(class_2561.method_30163((String)(" (" + (this.page + 1) + "/" + (this.getMaxPage() + 1) + ")"))));
        for (int row = 0; row < GRID.length; ++row) {
            for (int col = 0; col < GRID[row].length; ++col) {
                String c = GRID[row][col];
                int slot = row * 9 + col;
                if (c.equalsIgnoreCase("X")) {
                    GuiElementBuilder builder = new GuiElementBuilder().setItem(class_1802.field_8162);
                    builder.setCallback(this::clickIcon);
                    this.displayList.add(builder);
                    this.setSlot(slot, (GuiElementBuilderInterface)builder);
                }
                if (c.equalsIgnoreCase("B")) {
                    this.setSlot(slot, (GuiElementBuilderInterface)this.back);
                }
                if (c.equalsIgnoreCase("N")) {
                    this.setSlot(slot, (GuiElementBuilderInterface)this.next);
                }
                if (c.equalsIgnoreCase("P")) {
                    this.setSlot(slot, (GuiElementBuilderInterface)this.prev);
                }
                if (!c.equalsIgnoreCase("W")) continue;
                this.setSlot(slot, (GuiElementBuilderInterface)new GuiElementBuilder().setItem(RDGuiItems.EMPTY_SLOT));
            }
        }
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        this.updated = true;
        return super.onAnyClick(index, type, action);
    }

    public void clickIcon(int index, ClickType clickType, class_1713 action) {
        int iconIndex = this.page * 45 + index;
        if (this.maxSize > iconIndex) {
            // empty if block
        }
    }

    public void back(int index, ClickType clickType, class_1713 action) {
        this.player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
        if (this.prevGuiCallback != null) {
            SimpleGui applyGui = this.prevGuiCallback.apply();
            applyGui.open();
        }
    }

    public void next(int index, ClickType clickType, class_1713 action) {
        this.player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
        if (this.page < this.getMaxPage()) {
            ++this.page;
            this.displayList.clear();
        }
    }

    public void prev(int index, ClickType clickType, class_1713 action) {
        this.player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
        if (this.page > this.getMinPage()) {
            --this.page;
            this.displayList.clear();
        }
    }

    public int getMinPage() {
        return 0;
    }

    public int getMaxPage() {
        return Math.max(0, (this.maxSize - 1) / 45);
    }

    public void onTick() {
        super.onTick();
        if (!this.updated) {
            return;
        }
        this.updated = false;
        this.setTitle((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)this.recipeGuiInfo.getId().method_42094())).method_10852(class_2561.method_30163((String)(" (" + (this.page + 1) + "/" + (this.getMaxPage() + 1) + ")"))));
        int start = this.page * 45;
        for (int i = 0; i < 45; ++i) {
            int slotIndex = i;
            int recipeIndex = start + i;
            if (recipeIndex < this.maxSize) {
                GuiStackBuilder stackGetter = this.recipeTypeInfo.getGetter();
                stackGetter.apply(this, slotIndex);
                continue;
            }
            this.setSlot(this.getGridSlot(slotIndex), (GuiElementBuilderInterface)new GuiElementBuilder().setItem(class_1802.field_8162));
        }
    }

    public int getGridSlot(int index) {
        int counter = 0;
        for (int row = 0; row < GRID.length; ++row) {
            for (int col = 0; col < GRID[row].length; ++col) {
                if (!GRID[row][col].equalsIgnoreCase("X")) continue;
                if (counter == index) {
                    return row * 9 + col;
                }
                ++counter;
            }
        }
        return -1;
    }

    @Generated
    public GuiElementBuilder getBack() {
        return this.back;
    }

    @Generated
    public GuiElementBuilder getNext() {
        return this.next;
    }

    @Generated
    public GuiElementBuilder getPrev() {
        return this.prev;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public int getMaxSize() {
        return this.maxSize;
    }

    @Generated
    public List<GuiElementBuilder> getDisplayList() {
        return this.displayList;
    }

    @Generated
    public RecipeTypeGuiInfo<? extends BasePageGui> getRecipeGuiInfo() {
        return this.recipeGuiInfo;
    }

    @Generated
    public RecipeTypeInfo getRecipeTypeInfo() {
        return this.recipeTypeInfo;
    }

    @Generated
    public List<RecipeEntryWrapper<?>> getEntries() {
        return this.entries;
    }

    @Generated
    public boolean isUpdated() {
        return this.updated;
    }

    @Generated
    public GuiOpeningPrevCallback getPrevGuiCallback() {
        return this.prevGuiCallback;
    }
}

