/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.gui.recipe;

import cc.thonly.reverie_dreams.gui.BasePageGui;
import cc.thonly.reverie_dreams.gui.RecipeTypeCategoryManager;
import cc.thonly.reverie_dreams.gui.recipe.RecipeTypeGuiInfo;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1713;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;

public class RecipeTypeCategoryGui
extends SimpleGui {
    public static final String[][] GRID = new String[][]{{"X", "X", "X", "X", "X", "X", "X", "X", "X"}, {"X", "X", "X", "X", "X", "X", "X", "X", "X"}, {"X", "X", "X", "X", "X", "X", "X", "X", "X"}, {"X", "X", "X", "X", "X", "X", "X", "X", "X"}, {"X", "X", "X", "X", "X", "X", "X", "X", "X"}, {"P", "W", "W", "W", "W", "W", "W", "W", "N"}};
    public static final int PER_PAGE_SIZE = 45;
    public final List<GuiElementBuilder> recipeElements = new LinkedList<GuiElementBuilder>();
    public final GuiElementBuilder next = new GuiElementBuilder().setItem(class_1802.field_8575).setSkullOwner("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzg2MTg1YjFkNTE5YWRlNTg1ZjE4NGMzNGYzZjNlMjBiYjY0MWRlYjg3OWU4MTM3OGU0ZWFmMjA5Mjg3In19fQ").setItemName(class_2561.method_30163((String)"Next Page")).setCallback(this::next);
    public final GuiElementBuilder prev = new GuiElementBuilder().setItem(class_1802.field_8575).setSkullOwner("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzEwODI5OGZmMmIyNjk1MWQ2ODNlNWFkZTQ2YTQyZTkwYzJmN2M3ZGQ0MWJhYTkwOGJjNTg1MmY4YzMyZTU4MyJ9fX0").setItemName(class_2561.method_30163((String)"Prev Page")).setCallback(this::prev);
    public int page = 0;

    public RecipeTypeCategoryGui(class_3222 player) {
        super(class_3917.field_17327, player, false);
        this.init();
    }

    public RecipeTypeCategoryGui(class_3222 player, int page) {
        this(player);
        this.page = page;
    }

    public static RecipeTypeCategoryGui create(class_3222 player) {
        RecipeTypeCategoryGui recipeTypeCategoryGui = new RecipeTypeCategoryGui(player);
        recipeTypeCategoryGui.open();
        return recipeTypeCategoryGui;
    }

    public void init() {
        for (int row = 0; row < GRID.length; ++row) {
            for (int col = 0; col < GRID[row].length; ++col) {
                String c = GRID[row][col];
                int slot = row * 9 + col;
                if (c.equalsIgnoreCase("X")) {
                    GuiElementBuilder builder = new GuiElementBuilder().setItem(class_1802.field_8162);
                    builder.setCallback(this::clickIcon);
                    this.recipeElements.add(builder);
                    this.setSlot(slot, (GuiElementBuilderInterface)builder);
                }
                if (c.equalsIgnoreCase("N")) {
                    this.setSlot(slot, (GuiElementBuilderInterface)this.next);
                }
                if (c.equalsIgnoreCase("P")) {
                    this.setSlot(slot, (GuiElementBuilderInterface)this.prev);
                }
                if (!c.equalsIgnoreCase("W")) continue;
                this.setSlot(slot, (GuiElementBuilderInterface)new GuiElementBuilder().setItem(class_1802.field_8736));
            }
        }
    }

    public void clickIcon(int index, ClickType clickType, class_1713 action) {
        int iconIndex = this.page * 45 + index;
        if (RecipeTypeCategoryManager.CATEGORY_ENTRIES.size() > iconIndex) {
            RecipeTypeGuiInfo<? extends BasePageGui> recipeTypeGuiInfo = RecipeTypeCategoryManager.CATEGORY_ENTRIES.get(iconIndex);
        }
    }

    public void next(int index, ClickType clickType, class_1713 action) {
        this.player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
        if (this.page < this.getMaxPage()) {
            ++this.page;
        }
    }

    public void prev(int index, ClickType clickType, class_1713 action) {
        this.player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
        if (this.page > this.getMinPage()) {
            --this.page;
        }
    }

    public int getMinPage() {
        return 0;
    }

    public int getMaxPage() {
        return Math.max(0, (this.recipeElements.size() - 1) / 45);
    }

    public void onTick() {
        super.onTick();
        this.setTitle(class_2561.method_30163((String)("Recipes Manager (" + (this.page + 1) + "/" + (this.getMaxPage() + 1) + ")")));
        int start = this.page * 45;
        for (int i = 0; i < 45; ++i) {
            int slotIndex = i;
            int recipeIndex = start + i;
            if (recipeIndex < RecipeTypeCategoryManager.CATEGORY_ENTRIES.size()) {
                RecipeTypeGuiInfo<? extends BasePageGui> recipeTypeGuiInfo = RecipeTypeCategoryManager.CATEGORY_ENTRIES.get(recipeIndex + this.page * 45);
                GuiElementBuilder icon = new GuiElementBuilder().setItem(recipeTypeGuiInfo.getIcon().method_7909()).setItemName((class_2561)class_2561.method_43471((String)recipeTypeGuiInfo.getId().method_42094())).setLore(List.of()).setCallback((slot, click, action) -> {
                    this.close();
                    this.player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
                    recipeTypeGuiInfo.create(this.player, () -> new RecipeTypeCategoryGui(this.player, this.page));
                });
                this.setSlot(this.getGridSlot(slotIndex), (GuiElementBuilderInterface)icon);
                continue;
            }
            this.setSlot(this.getGridSlot(slotIndex), (GuiElementBuilderInterface)new GuiElementBuilder().setItem(class_1802.field_8162));
        }
    }

    private int getGridSlot(int index) {
        int count = 0;
        for (int row = 0; row < GRID.length; ++row) {
            for (int col = 0; col < GRID[row].length; ++col) {
                if (!GRID[row][col].equalsIgnoreCase("X")) continue;
                if (count == index) {
                    return row * 9 + col;
                }
                ++count;
            }
        }
        return -1;
    }
}

