/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeItemTag {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecipeItemTag.class);
    private static final Map<class_2960, RecipeItemTag> INSTANCES = new ConcurrentHashMap<class_2960, RecipeItemTag>();
    private final class_2960 recipeTagId;
    private final Set<class_1792> entries = new HashSet<class_1792>();
    private final Set<class_2960> preparingItemIdentifiers = new HashSet<class_2960>();
    private Set<class_1792> cachedResolvedEntries = null;

    private RecipeItemTag(class_2960 recipeTagId) {
        this.recipeTagId = recipeTagId;
    }

    public synchronized RecipeItemTag addItem(class_1792 ... items) {
        Collections.addAll(this.entries, items);
        this.invalidateCache();
        return this;
    }

    public synchronized RecipeItemTag removeItem(class_1792 ... items) {
        for (class_1792 item : items) {
            this.entries.remove(item);
        }
        this.invalidateCache();
        return this;
    }

    public synchronized RecipeItemTag addItemIdentifier(class_1792 ... items) {
        for (class_1792 item : items) {
            this.preparingItemIdentifiers.add(class_7923.field_41178.method_10221((Object)item));
        }
        this.invalidateCache();
        return this;
    }

    public synchronized RecipeItemTag addItemIdentifier(class_2960 ... items) {
        Collections.addAll(this.preparingItemIdentifiers, items);
        this.invalidateCache();
        return this;
    }

    public synchronized RecipeItemTag addItemIdentifier(String ... items) {
        for (String s : items) {
            this.preparingItemIdentifiers.add(class_2960.method_60654((String)s));
        }
        this.invalidateCache();
        return this;
    }

    public synchronized RecipeItemTag removeItemIdentifier(class_2960 ... items) {
        for (class_2960 id : items) {
            this.preparingItemIdentifiers.remove(id);
        }
        this.invalidateCache();
        return this;
    }

    public synchronized RecipeItemTag addFromTagKey(class_5455 registryManager, class_6862<class_1792> itemTagKey) {
        Optional optionalRegistry = registryManager.method_46759(class_7924.field_41197);
        if (optionalRegistry.isPresent()) {
            class_2378 registry = (class_2378)optionalRegistry.get();
            for (class_6880 itemEntry : registry.method_40286(itemTagKey)) {
                this.addItemIdentifier(class_7923.field_41178.method_10221((Object)((class_1792)itemEntry.comp_349())));
            }
            this.invalidateCache();
        } else {
            log.error("Can't read item tag id {} ", (Object)itemTagKey.comp_327());
        }
        return this;
    }

    public void forEach(Consumer<? super class_1792> action) {
        this.getEntries().forEach(action);
    }

    public Stream<class_1792> stream() {
        return this.getEntries().stream();
    }

    public List<class_1792> asList() {
        return new ArrayList<class_1792>(this.getEntries());
    }

    public synchronized Set<class_1792> getEntries() {
        if (this.cachedResolvedEntries == null) {
            HashSet<class_1792> result = new HashSet<class_1792>(this.entries);
            for (class_2960 id : this.preparingItemIdentifiers) {
                class_1792 item = (class_1792)class_7923.field_41178.method_63535(id);
                if (item == class_1802.field_8162) continue;
                result.add(item);
            }
            this.cachedResolvedEntries = result;
        }
        return this.cachedResolvedEntries;
    }

    private void invalidateCache() {
        this.cachedResolvedEntries = null;
    }

    public static RecipeItemTag of(class_2960 recipeTagId) {
        return INSTANCES.computeIfAbsent(recipeTagId, RecipeItemTag::new);
    }

    public static RecipeItemTag of(class_5321<class_1792> registryKey) {
        return RecipeItemTag.of(registryKey.method_29177());
    }

    @Generated
    public class_2960 getRecipeTagId() {
        return this.recipeTagId;
    }
}

