/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.recipe;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.api.RecipeCompatPatchesCallback;
import cc.thonly.reverie_dreams.api.RecipeCompatPatchesImpl;
import cc.thonly.reverie_dreams.api.RecipeInjectCallback;
import cc.thonly.reverie_dreams.recipe.BaseRecipe;
import cc.thonly.reverie_dreams.recipe.BaseRecipeType;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.entry.DanmakuRecipe;
import cc.thonly.reverie_dreams.recipe.entry.DanmakuShapeDrawRecipe;
import cc.thonly.reverie_dreams.recipe.entry.GensokyoAltarRecipe;
import cc.thonly.reverie_dreams.recipe.entry.KitchenRecipe;
import cc.thonly.reverie_dreams.recipe.entry.StrengthTableRecipe;
import cc.thonly.reverie_dreams.recipe.type.DanmakuRecipeType;
import cc.thonly.reverie_dreams.recipe.type.DanmakuShapeDrawRecipeType;
import cc.thonly.reverie_dreams.recipe.type.GensokyoAltarRecipeType;
import cc.thonly.reverie_dreams.recipe.type.KitchenRecipeType;
import cc.thonly.reverie_dreams.recipe.type.StrengthTableRecipeType;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Method;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecipeManager.class);
    public static final Map<class_2960, BaseRecipeType<?>> RECIPE_TYPES = new Object2ObjectOpenHashMap();
    public static final BaseRecipeType<DanmakuRecipe> DANMAKU_TYPE = RecipeManager.registerRecipeType(ReverieDreams.id("danmaku"), new DanmakuRecipeType());
    public static final BaseRecipeType<DanmakuShapeDrawRecipe> DANMAKU_SHAPE_DRAW_TYPE = RecipeManager.registerRecipeType(ReverieDreams.id("danmaku_shape_draw"), new DanmakuShapeDrawRecipeType());
    public static final BaseRecipeType<GensokyoAltarRecipe> GENSOKYO_ALTAR = RecipeManager.registerRecipeType(ReverieDreams.id("gensokyo_altar"), new GensokyoAltarRecipeType());
    public static final BaseRecipeType<StrengthTableRecipe> STRENGTH_TABLE = RecipeManager.registerRecipeType(ReverieDreams.id("strength_table"), new StrengthTableRecipeType());
    public static final BaseRecipeType<KitchenRecipe> KITCHEN_TYPE = RecipeManager.registerRecipeType(ReverieDreams.id("kitchen"), new KitchenRecipeType());

    public static void bootstrap() {
    }

    public static BaseRecipe getFromOutput(class_1792 item) {
        for (Map.Entry<class_2960, BaseRecipeType<?>> recipeTypeEntry : RECIPE_TYPES.entrySet()) {
            Map<class_2960, ?> registryView = recipeTypeEntry.getValue().getRegistryView();
            for (Map.Entry<class_2960, ?> recipeEntry : registryView.entrySet()) {
                Object recipeObj = recipeEntry.getValue();
                ItemStackWrapper wrapper = RecipeManager.getOutputReflective(recipeObj);
                if (wrapper == null || wrapper.getItem() != item) continue;
                return (BaseRecipe)recipeObj;
            }
        }
        return null;
    }

    public static ItemStackWrapper getOutputReflective(Object recipeObj) {
        try {
            Method method = recipeObj.getClass().getMethod("getOutput", new Class[0]);
            Object result = method.invoke(recipeObj, new Object[0]);
            if (result instanceof ItemStackWrapper) {
                ItemStackWrapper wrapper = (ItemStackWrapper)result;
                return wrapper;
            }
        }
        catch (Exception e) {
            log.error("Can't invoke getOutput: {}", recipeObj.getClass());
        }
        return null;
    }

    public static void onReload(class_3300 manager) {
        RecipeCompatPatchesImpl.Builder.INSTANCE.clear();
        RECIPE_TYPES.forEach((key, recipeType) -> {
            try {
                recipeType.removeAll();
                recipeType.reload(manager);
                recipeType.sort();
                recipeType.assignRawId();
                ((RecipeCompatPatchesCallback)RecipeCompatPatchesCallback.EVENT.invoker()).onLoad();
                ((RecipeInjectCallback)RecipeInjectCallback.EVENT.invoker()).onLoad((BaseRecipeType<?>)recipeType);
                log.info("Reloaded Recipe Type {}", (Object)key.toString());
                RecipeCompatPatchesImpl.apply(recipeType);
            }
            catch (Exception e) {
                log.error("Can't reload recipes {}, {}", key, (Object)e);
            }
        });
    }

    public static <R extends BaseRecipe, BR extends BaseRecipeType<R>> BR registerRecipeType(class_2960 id, BR recipeType) {
        RegistryHandlers.register(RegistryHandlers.RECIPE_TYPE, id, recipeType);
        RECIPE_TYPES.put(id, recipeType);
        recipeType.bootstrap();
        assert (id == recipeType.getId());
        return recipeType;
    }
}

