/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.server.MinecraftServer;

public class DelayedTask {
    public static final List<DelayedTask> TASKS = new ArrayList<DelayedTask>();
    private MinecraftServer server;
    private float ticksLeft;
    private Runnable action;

    public DelayedTask(MinecraftServer server, float ticksLeft, Runnable action) {
        this.server = server;
        this.ticksLeft = ticksLeft;
        this.action = action;
        TASKS.add(this);
    }

    public static synchronized DelayedTask create(MinecraftServer server, float ticksLeft, Runnable action) {
        return new DelayedTask(server, ticksLeft, action);
    }

    public static synchronized DelayedTask createFromSecond(MinecraftServer server, float second, Runnable action) {
        return new DelayedTask(server, second * 20.0f, action);
    }

    public static synchronized void when(MinecraftServer server, BooleanPredicate predicate, float intervalSeconds, Runnable action, Runnable elseAction) {
        DelayedTask.createFromSecond(server, intervalSeconds, () -> {
            if (predicate.get().booleanValue()) {
                action.run();
            } else {
                elseAction.run();
                DelayedTask.when(server, predicate, intervalSeconds, action, elseAction);
            }
        });
    }

    public static synchronized void whenTick(MinecraftServer server, BooleanPredicate predicate, float intervalTick, Runnable action, Runnable elseAction) {
        DelayedTask.create(server, intervalTick, () -> {
            if (predicate.get().booleanValue()) {
                action.run();
            } else {
                elseAction.run();
                DelayedTask.whenTick(server, predicate, intervalTick, action, elseAction);
            }
        });
    }

    public static synchronized void repeat(MinecraftServer server, int times, float intervalSeconds, Runnable action) {
        if (times <= 0) {
            return;
        }
        DelayedTask.createFromSecond(server, intervalSeconds, () -> {
            action.run();
            DelayedTask.repeat(server, times - 1, intervalSeconds, action);
        });
    }

    public static synchronized void repeat(MinecraftServer server, int times, int intervalTick, Runnable action) {
        if (times <= 0) {
            return;
        }
        DelayedTask.create(server, intervalTick, () -> {
            action.run();
            DelayedTask.repeat(server, times - 1, intervalTick, action);
        });
    }

    public static synchronized void tick(MinecraftServer server) {
        Set collect = TASKS.stream().filter(t -> t.server.equals(server)).collect(Collectors.toSet());
        for (DelayedTask task : collect) {
            task.tick();
        }
    }

    public void stop() {
        TASKS.remove(this);
    }

    public synchronized boolean tick() {
        float f;
        this.ticksLeft -= 1.0f;
        if (f <= 0.0f) {
            this.action.run();
            TASKS.remove(this);
            return true;
        }
        return false;
    }

    @Generated
    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    @Generated
    public void setTicksLeft(float ticksLeft) {
        this.ticksLeft = ticksLeft;
    }

    @Generated
    public void setAction(Runnable action) {
        this.action = action;
    }

    @Generated
    public MinecraftServer getServer() {
        return this.server;
    }

    @Generated
    public float getTicksLeft() {
        return this.ticksLeft;
    }

    @Generated
    public Runnable getAction() {
        return this.action;
    }

    @Generated
    public String toString() {
        return "DelayedTask(server=" + String.valueOf(this.getServer()) + ", ticksLeft=" + this.getTicksLeft() + ", action=" + String.valueOf(this.getAction()) + ")";
    }

    public static interface BooleanPredicate {
        public Boolean get();
    }
}

