/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.server;

import cc.thonly.reverie_dreams.util.PairWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import lombok.Generated;
import net.minecraft.class_10185;
import net.minecraft.class_2596;
import net.minecraft.class_2848;
import net.minecraft.class_2851;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class PlayerInputManager {
    private static PlayerInputManager INSTANCE = null;
    public static Stack<PairWrapper<class_3222, class_2596<?>>> TICK_PLAYER_QUEUE = new Stack();
    private final List<class_3222> FORWARDS = new ArrayList<class_3222>();
    private final List<class_3222> BACKWARDS = new ArrayList<class_3222>();
    private final List<class_3222> LEFTS = new ArrayList<class_3222>();
    private final List<class_3222> RIGHTS = new ArrayList<class_3222>();
    private final List<class_3222> JUMPS = new ArrayList<class_3222>();
    private final List<class_3222> SNEAKS = new ArrayList<class_3222>();
    private final List<class_3222> SPRINTS = new ArrayList<class_3222>();
    private final List<List<class_3222>> LIST = List.of(this.FORWARDS, this.BACKWARDS, this.LEFTS, this.RIGHTS, this.JUMPS, this.SNEAKS, this.SPRINTS);
    private final Map<class_3222, class_10185> currentInputs = new HashMap<class_3222, class_10185>();

    private PlayerInputManager() {
    }

    public static void tick(MinecraftServer server) {
        PlayerInputManager inputManager = PlayerInputManager.getInstance();
        inputManager.tickServer(server);
    }

    public synchronized void tickServer(MinecraftServer server) {
        for (List<class_3222> playerEntities : this.LIST) {
            playerEntities.clear();
        }
        while (!TICK_PLAYER_QUEUE.isEmpty()) {
            PairWrapper<class_3222, class_2596<?>> wrapper = TICK_PLAYER_QUEUE.pop();
            class_3222 player = wrapper.getKey();
            class_2596<?> packet = wrapper.getValue();
            if (packet instanceof class_2851) {
                class_2851 inputC2SPacket = (class_2851)packet;
                class_10185 input = inputC2SPacket.comp_3139();
                this.currentInputs.put(player, input);
                if (input.comp_3159()) {
                    this.FORWARDS.add(player);
                }
                if (input.comp_3160()) {
                    this.BACKWARDS.add(player);
                }
                if (input.comp_3161()) {
                    this.LEFTS.add(player);
                }
                if (input.comp_3162()) {
                    this.RIGHTS.add(player);
                }
                if (input.comp_3163()) {
                    this.JUMPS.add(player);
                }
                if (input.comp_3164()) {
                    this.SNEAKS.add(player);
                }
                if (input.comp_3165()) {
                    this.SPRINTS.add(player);
                }
            }
            if (!(packet instanceof class_2848)) continue;
            class_2848 cCC2SPacket = (class_2848)packet;
            class_2848.class_2849 mode = cCC2SPacket.method_12365();
            if (player.method_5715()) {
                this.SNEAKS.add(player);
            } else {
                this.SNEAKS.remove(player);
            }
            if (mode.equals((Object)class_2848.class_2849.field_12981)) {
                this.SPRINTS.add(player);
            }
            if (!mode.equals((Object)class_2848.class_2849.field_12985)) continue;
            this.SPRINTS.remove(player);
        }
    }

    public static synchronized boolean isKeyPressed(class_3222 player, InputKey key) {
        PlayerInputManager inputManager = PlayerInputManager.getInstance();
        return switch (key.ordinal()) {
            case 0 -> inputManager.FORWARDS.contains(player);
            case 1 -> inputManager.BACKWARDS.contains(player);
            case 2 -> inputManager.LEFTS.contains(player);
            case 3 -> inputManager.RIGHTS.contains(player);
            case 4 -> inputManager.JUMPS.contains(player);
            case 6 -> inputManager.SPRINTS.contains(player);
            default -> false;
        };
    }

    public static synchronized boolean isKeyDown(class_3222 player, InputKey key) {
        PlayerInputManager inputManager = PlayerInputManager.getInstance();
        class_10185 input = inputManager.currentInputs.get(player);
        if (input == null) {
            return false;
        }
        return switch (key.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> input.comp_3159();
            case 1 -> input.comp_3160();
            case 2 -> input.comp_3161();
            case 3 -> input.comp_3162();
            case 4 -> input.comp_3163();
            case 5 -> input.comp_3164();
            case 6 -> input.comp_3165();
        };
    }

    public static synchronized PlayerInputManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlayerInputManager();
        }
        return INSTANCE;
    }

    public synchronized PlayerInputManager reload() {
        INSTANCE = new PlayerInputManager();
        return INSTANCE;
    }

    @Generated
    public List<class_3222> getFORWARDS() {
        return this.FORWARDS;
    }

    @Generated
    public List<class_3222> getBACKWARDS() {
        return this.BACKWARDS;
    }

    @Generated
    public List<class_3222> getLEFTS() {
        return this.LEFTS;
    }

    @Generated
    public List<class_3222> getRIGHTS() {
        return this.RIGHTS;
    }

    @Generated
    public List<class_3222> getJUMPS() {
        return this.JUMPS;
    }

    @Generated
    public List<class_3222> getSNEAKS() {
        return this.SNEAKS;
    }

    @Generated
    public List<class_3222> getSPRINTS() {
        return this.SPRINTS;
    }

    @Generated
    public List<List<class_3222>> getLIST() {
        return this.LIST;
    }

    @Generated
    public Map<class_3222, class_10185> getCurrentInputs() {
        return this.currentInputs;
    }

    public static enum InputKey {
        FORWARD,
        BACKWARD,
        LEFT,
        RIGHT,
        JUMP,
        SNEAK,
        SPRINT;


        public static Optional<InputKey> fromString(String str) {
            try {
                return Optional.of(InputKey.valueOf(str.trim().toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }
    }
}

