/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.util.math;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableObject<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VariableObject.class);
    private T value;

    public VariableObject(T value) {
        this.value = value;
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public T increment() {
        return this.add(1);
    }

    public T decrement() {
        return this.subtract(1);
    }

    public T add(Number other) {
        this.value = this.operate(other, Operation.ADD);
        return this.value;
    }

    public T subtract(Number other) {
        this.value = this.operate(other, Operation.SUBTRACT);
        return this.value;
    }

    public T multiply(Number other) {
        this.value = this.operate(other, Operation.MULTIPLY);
        return this.value;
    }

    public T divide(Number other) {
        this.value = this.operate(other, Operation.DIVIDE);
        return this.value;
    }

    private T operate(Number other, Operation op) {
        T t = this.value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, Float.class, Double.class}, t, n)) {
            case 0: {
                Integer integer = (Integer)t;
                int result = this.apply(((Number)this.value).intValue(), other.intValue(), op);
                return (T)Integer.valueOf(result);
            }
            case 1: {
                Long l = (Long)t;
                long result = this.apply(((Number)this.value).longValue(), other.longValue(), op);
                return (T)Long.valueOf(result);
            }
            case 2: {
                Float v = (Float)t;
                float result = this.apply(((Number)this.value).floatValue(), other.floatValue(), op);
                return (T)Float.valueOf(result);
            }
            case 3: {
                Double v = (Double)t;
                double result = this.apply(((Number)this.value).doubleValue(), other.doubleValue(), op);
                return (T)Double.valueOf(result);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(this.value != null ? this.value.getClass() : Object.class));
    }

    private int apply(int a, int b, Operation op) {
        return switch (op.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> a + b;
            case 1 -> a - b;
            case 2 -> a * b;
            case 3 -> a / b;
        };
    }

    private long apply(long a, long b, Operation op) {
        return switch (op.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> a + b;
            case 1 -> a - b;
            case 2 -> a * b;
            case 3 -> a / b;
        };
    }

    private float apply(float a, float b, Operation op) {
        return switch (op.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> a + b;
            case 1 -> a - b;
            case 2 -> a * b;
            case 3 -> a / b;
        };
    }

    private double apply(double a, double b, Operation op) {
        return switch (op.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> a + b;
            case 1 -> a - b;
            case 2 -> a * b;
            case 3 -> a / b;
        };
    }

    public T mod(Number other) {
        T t = this.value;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        return (T)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, Float.class, Double.class}, t2, n)) {
            case 0 -> {
                Integer i = (Integer)t2;
                yield i % other.intValue();
            }
            case 1 -> {
                Long l = (Long)t2;
                yield l % other.longValue();
            }
            case 2 -> {
                Float f = (Float)t2;
                yield Float.valueOf(f.floatValue() % other.floatValue());
            }
            case 3 -> {
                Double d = (Double)t2;
                yield d % other.doubleValue();
            }
            default -> throw new UnsupportedOperationException("Unsupported type for mod: " + String.valueOf(this.value.getClass()));
        });
    }

    public T abs() {
        T t = this.value;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        return (T)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, Float.class, Double.class}, t2, n)) {
            case 0 -> {
                Integer i = (Integer)t2;
                yield Math.abs(i);
            }
            case 1 -> {
                Long l = (Long)t2;
                yield Math.abs(l);
            }
            case 2 -> {
                Float f = (Float)t2;
                yield Float.valueOf(Math.abs(f.floatValue()));
            }
            case 3 -> {
                Double d = (Double)t2;
                yield Math.abs(d);
            }
            default -> throw new UnsupportedOperationException("Unsupported type for abs: " + String.valueOf(this.value.getClass()));
        });
    }

    public T negate() {
        T t = this.value;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        return (T)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, Float.class, Double.class}, t2, n)) {
            case 0 -> {
                Integer i = (Integer)t2;
                yield -i.intValue();
            }
            case 1 -> {
                Long l = (Long)t2;
                yield -l.longValue();
            }
            case 2 -> {
                Float f = (Float)t2;
                yield Float.valueOf(-f.floatValue());
            }
            case 3 -> {
                Double d = (Double)t2;
                yield -d.doubleValue();
            }
            default -> throw new UnsupportedOperationException("Unsupported type for negate: " + String.valueOf(this.value.getClass()));
        });
    }

    public int intValue() {
        return ((Number)this.value).intValue();
    }

    public long longValue() {
        return ((Number)this.value).longValue();
    }

    public float floatValue() {
        return ((Number)this.value).floatValue();
    }

    public double doubleValue() {
        return ((Number)this.value).doubleValue();
    }

    public boolean greaterThan(Number other) {
        return ((Number)this.value).doubleValue() > other.doubleValue();
    }

    public boolean lessThan(Number other) {
        return ((Number)this.value).doubleValue() < other.doubleValue();
    }

    public boolean equalsTo(Number other) {
        return Double.compare(((Number)this.value).doubleValue(), other.doubleValue()) == 0;
    }

    public boolean test(Predicate<T> predicate) {
        return predicate.test(this.value);
    }

    public <R> R map(Function<T, R> mapper) {
        return mapper.apply(this.value);
    }

    @Nullable
    public <R> R getTryCast(Class<R> rClass) {
        try {
            return (R)this.value;
        }
        catch (Exception exception) {
            log.error("{0}", (Throwable)exception);
            return null;
        }
    }

    public void apply(Consumer<T> consumer) {
        consumer.accept(this.value);
    }

    public VariableObject<T> with(T newValue) {
        this.value = newValue;
        return this;
    }

    public static <T> VariableObject<T> of(T value) {
        return new VariableObject<T>(value);
    }

    @Generated
    public String toString() {
        return "VariableObject(value=" + String.valueOf(this.value) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariableObject)) {
            return false;
        }
        VariableObject other = (VariableObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.value;
        T other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VariableObject;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    private static enum Operation {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE;

    }
}

