/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.util.network;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModrinthAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModrinthAPI.class);
    public static final String API = "https://api.modrinth.com/v2/project/gensokyo-reverie-of-lost-dreams/version";
    public static final String USER_AGENT = "SAGUMEDREAM/ReverieDreams (helper@thonly.cc)";

    public static int compareVersion(String v1, String v2) {
        String[] mc2;
        String mcVer2;
        String[] split1 = v1.split("\\+", 2);
        String[] split2 = v2.split("\\+", 2);
        String main1 = split1[0];
        String main2 = split2[0];
        String suffix1 = split1.length > 1 ? split1[1] : "";
        String suffix2 = split2.length > 1 ? split2[1] : "";
        int cmp = ModrinthAPI.compareNumericVersion(main1, main2);
        if (cmp != 0) {
            return cmp;
        }
        String[] mc1 = suffix1.split("-", 2);
        String mcVer1 = mc1.length > 0 ? mc1[0] : "";
        cmp = ModrinthAPI.compareNumericVersion(mcVer1, mcVer2 = (mc2 = suffix2.split("-", 2)).length > 0 ? mc2[0] : "");
        if (cmp != 0) {
            return cmp;
        }
        String tag1 = mc1.length > 1 ? mc1[1] : "";
        String tag2 = mc2.length > 1 ? mc2[1] : "";
        return ModrinthAPI.compareTag(tag1, tag2);
    }

    private static int compareNumericVersion(String v1, String v2) {
        if (v1.isEmpty() && v2.isEmpty()) {
            return 0;
        }
        if (v1.isEmpty()) {
            return -1;
        }
        if (v2.isEmpty()) {
            return 1;
        }
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int len = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < len; ++i) {
            int num2;
            int num1 = i < parts1.length ? ModrinthAPI.parseSafe(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? ModrinthAPI.parseSafe(parts2[i]) : 0;
            if (num1 == num2) continue;
            return Integer.compare(num1, num2);
        }
        return 0;
    }

    private static int parseSafe(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static int compareTag(String t1, String t2) {
        return Integer.compare(ModrinthAPI.tagRank(t1), ModrinthAPI.tagRank(t2));
    }

    private static int tagRank(String tag) {
        return switch (tag.toLowerCase()) {
            case "alpha" -> 0;
            case "beta" -> 1;
            case "", "stable", "release" -> 2;
            default -> 3;
        };
    }

    public static Entry get() {
        try {
            URI uri = new URI(API);
            URL url = uri.toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", USER_AGENT);
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed to fetch data: HTTP " + conn.getResponseCode());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
            reader.close();
            conn.disconnect();
            if (!jsonArray.isEmpty()) {
                return (Entry)new Gson().fromJson(jsonArray.get(0), Entry.class);
            }
        }
        catch (Exception e) {
            log.error("Can't get new version");
        }
        return null;
    }

    public static class Entry {
        String id;
        String name;
        String version_number;
        String changelog;
        String date_published;
        int downloads;
        FileInfo[] files;

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVersion_number() {
            return this.version_number;
        }

        @Generated
        public String getChangelog() {
            return this.changelog;
        }

        @Generated
        public String getDate_published() {
            return this.date_published;
        }

        @Generated
        public int getDownloads() {
            return this.downloads;
        }

        @Generated
        public FileInfo[] getFiles() {
            return this.files;
        }

        @Generated
        public String toString() {
            return "ModrinthAPI.Entry(id=" + this.getId() + ", name=" + this.getName() + ", version_number=" + this.getVersion_number() + ", changelog=" + this.getChangelog() + ", date_published=" + this.getDate_published() + ", downloads=" + this.getDownloads() + ", files=" + Arrays.deepToString(this.getFiles()) + ")";
        }

        public static class FileInfo {
            String url;
            String filename;
            long size;

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public String getFilename() {
                return this.filename;
            }

            @Generated
            public long getSize() {
                return this.size;
            }

            @Generated
            public String toString() {
                return "ModrinthAPI.Entry.FileInfo(url=" + this.getUrl() + ", filename=" + this.getFilename() + ", size=" + this.getSize() + ")";
            }
        }
    }
}

