/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.util.network;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;

public class MojangSkinFetcher {
    private static final Gson gson = new Gson();

    public static JsonObject getSignedSkin(String usernameOrUuid) throws Exception {
        String uuid = usernameOrUuid.replace("-", "");
        if (!uuid.matches("^[0-9a-fA-F]{32}$")) {
            URI uuidUri = new URI("https://api.mojang.com/users/profiles/minecraft/" + usernameOrUuid);
            URL uuidUrl = uuidUri.toURL();
            HttpURLConnection uuidConn = (HttpURLConnection)uuidUrl.openConnection();
            uuidConn.setRequestMethod("GET");
            if (uuidConn.getResponseCode() != 200) {
                throw new IllegalArgumentException("\u73a9\u5bb6\u540d\u4e0d\u5b58\u5728: " + usernameOrUuid);
            }
            JsonObject uuidJson = (JsonObject)gson.fromJson((Reader)new InputStreamReader(uuidConn.getInputStream()), JsonObject.class);
            uuid = uuidJson.get("id").getAsString();
        }
        URL skinUrl = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
        HttpURLConnection skinConn = (HttpURLConnection)skinUrl.openConnection();
        skinConn.setRequestMethod("GET");
        if (skinConn.getResponseCode() != 200) {
            throw new IllegalStateException("\u83b7\u53d6\u76ae\u80a4\u5931\u8d25\uff08\u53ef\u80fd\u73a9\u5bb6\u6ca1\u6709\u6539\u8fc7\u76ae\u80a4\u6216\u4e0d\u662f\u6b63\u7248\uff09");
        }
        JsonObject profileJson = (JsonObject)gson.fromJson((Reader)new InputStreamReader(skinConn.getInputStream()), JsonObject.class);
        JsonArray properties = profileJson.getAsJsonArray("properties");
        for (JsonElement element : properties) {
            JsonObject prop = element.getAsJsonObject();
            if (!"textures".equals(prop.get("name").getAsString())) continue;
            JsonObject result = new JsonObject();
            result.addProperty("id", profileJson.get("id").getAsString());
            result.addProperty("name", profileJson.get("name").getAsString());
            result.addProperty("value", prop.get("value").getAsString());
            result.addProperty("signature", prop.get("signature").getAsString());
            return result;
        }
        throw new IllegalStateException("\u672a\u627e\u5230\u76ae\u80a4\u4fe1\u606f");
    }
}

