/*
 * Decompiled with CFR 0.152.
 */
package nota;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1657;
import net.minecraft.server.MinecraftServer;
import nota.player.SongPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nota
implements ModInitializer {
    public static final String MOD_ID = "nota";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Nota");
    private static Nota instance;
    public MinecraftServer server;
    Map<UUID, ArrayList<SongPlayer>> playingSongs = new ConcurrentHashMap<UUID, ArrayList<SongPlayer>>();
    Map<UUID, Byte> playerVolume = new ConcurrentHashMap<UUID, Byte>();
    private boolean disabling = false;

    public static boolean isReceivingSong(class_1657 player) {
        return Nota.isReceivingSong(player.method_5667());
    }

    public static boolean isReceivingSong(UUID playerUuid) {
        ArrayList<SongPlayer> songs = Nota.instance.playingSongs.get(playerUuid);
        return songs != null && !songs.isEmpty();
    }

    public static void stopPlaying(class_1657 player) {
        Nota.stopPlaying(player.method_5667());
    }

    public static void stopPlaying(UUID playerUuid) {
        ArrayList<SongPlayer> songs = Nota.instance.playingSongs.get(playerUuid);
        if (songs == null) {
            return;
        }
        for (SongPlayer songPlayer : songs) {
            songPlayer.removePlayer(playerUuid);
        }
    }

    public static void setPlayerVolume(class_1657 player, byte volume) {
        Nota.setPlayerVolume(player.method_5667(), volume);
    }

    public static void setPlayerVolume(UUID playerUuid, byte volume) {
        Nota.instance.playerVolume.put(playerUuid, volume);
    }

    public static byte getPlayerVolume(class_1657 player) {
        return Nota.getPlayerVolume(player.method_5667());
    }

    public static byte getPlayerVolume(UUID playerUuid) {
        if (Nota.instance.playerVolume.containsKey(playerUuid)) {
            return Nota.instance.playerVolume.get(playerUuid);
        }
        Nota.instance.playerVolume.put(playerUuid, (byte)100);
        return 100;
    }

    public static ArrayList<SongPlayer> getSongPlayersByPlayer(class_1657 player) {
        return Nota.getSongPlayersByPlayer(player.method_5667());
    }

    public static ArrayList<SongPlayer> getSongPlayersByPlayer(UUID playerUuid) {
        return Nota.instance.playingSongs.get(playerUuid);
    }

    public static void setSongPlayersByPlayer(class_1657 player, ArrayList<SongPlayer> songs) {
        Nota.setSongPlayersByPlayer(player.method_5667(), songs);
    }

    public static void setSongPlayersByPlayer(UUID playerUuid, ArrayList<SongPlayer> songs) {
        Nota.instance.playingSongs.put(playerUuid, songs);
    }

    public boolean isDisabling() {
        return this.disabling;
    }

    public static Nota getAPI() {
        return instance;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public void onInitialize() {
        instance = this;
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            Nota.getAPI().disabling = false;
            Nota.getAPI().server = server;
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            Nota.getAPI().server = null;
            Nota.getAPI().disabling = true;
        });
    }
}

