/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import phanastrae.mirthdew_encore.block.MirthdewEncoreBlocks;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlStageManager;
import phanastrae.mirthdew_encore.dreamtwirl.stage.DreamtwirlStage;
import phanastrae.mirthdew_encore.dreamtwirl.stage.acherune.Acherune;
import phanastrae.mirthdew_encore.dreamtwirl.stage.acherune.StageAcherunes;

public class AcheruneHollowBlock
extends Block {
    public static final MapCodec<AcheruneHollowBlock> CODEC = AcheruneHollowBlock.simpleCodec(AcheruneHollowBlock::new);

    public MapCodec<AcheruneHollowBlock> codec() {
        return CODEC;
    }

    public AcheruneHollowBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean moved;
        BlockPos oldPos;
        StageAcherunes stageAcherunes;
        Acherune nearestAcherune;
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        DreamtwirlStage stage = DreamtwirlStageManager.getStage(level, pos);
        if (stage != null && (nearestAcherune = (stageAcherunes = stage.getStageAcherunes()).getNearestAcheruneToPos(pos, level.getRandom())) != null && pos.distSqr((Vec3i)(oldPos = nearestAcherune.getPos())) < 256.0 && (moved = stageAcherunes.moveAcherune(oldPos, pos))) {
            level.destroyBlock(oldPos, false);
            BlockState newState = MirthdewEncoreBlocks.GREATER_ACHERUNE.defaultBlockState();
            level.setBlock(pos, newState, 3);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            level.playSound(null, (double)oldPos.getX() + 0.5, (double)oldPos.getY() + 0.5, (double)oldPos.getZ() + 0.5, SoundEvents.GENERIC_EAT, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }
}

