/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.block;

import com.google.common.collect.Sets;
import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import phanastrae.mirthdew_encore.block.GreaterAcheruneBlock;
import phanastrae.mirthdew_encore.block.MirthdewEncoreBlocks;
import phanastrae.mirthdew_encore.particle.MirthdewEncoreParticleTypes;

public class AcherunePoweredBlock
extends Block {
    public static final IntegerProperty ACHERUNE_POWER = IntegerProperty.create((String)"acherune_power", (int)0, (int)31);
    public static final MapCodec<AcherunePoweredBlock> CODEC = AcherunePoweredBlock.simpleCodec(AcherunePoweredBlock::new);

    public MapCodec<AcherunePoweredBlock> codec() {
        return CODEC;
    }

    public AcherunePoweredBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACHERUNE_POWER, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACHERUNE_POWER});
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock()) && !level.isClientSide) {
            this.updatePowerStrength(level, pos, state);
            level.updateNeighborsAt(pos, (Block)this);
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, level, pos, newState, isMoving);
        if (!(isMoving || state.is(newState.getBlock()) || level.isClientSide)) {
            level.updateNeighborsAt(pos, (Block)this);
            this.updatePowerStrength(level, pos, state);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide) {
            this.updatePowerStrength(level, pos, state);
        }
    }

    private void updatePowerStrength(Level level, BlockPos pos, BlockState state) {
        int targetPower = this.calculateTargetPower(level, pos);
        if ((Integer)state.getValue((Property)ACHERUNE_POWER) != targetPower) {
            if (level.getBlockState(pos) == state) {
                level.setBlock(pos, (BlockState)state.setValue((Property)ACHERUNE_POWER, (Comparable)Integer.valueOf(targetPower)), 2);
            }
            HashSet updatePosSet = Sets.newHashSet();
            updatePosSet.add(pos);
            for (Direction direction : Direction.values()) {
                updatePosSet.add(pos.relative(direction));
            }
            for (BlockPos blockpos : updatePosSet) {
                level.updateNeighborsAt(blockpos, (Block)this);
            }
        }
    }

    private int calculateTargetPower(Level level, BlockPos pos) {
        if (level.getBlockState(pos.above()).isFaceSturdy((BlockGetter)level, pos, Direction.DOWN)) {
            return 0;
        }
        int power = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos adjPos = pos.relative(direction);
            BlockState adjState = level.getBlockState(adjPos);
            power = Math.max(power, AcherunePoweredBlock.getPower(adjState));
        }
        return Math.max(0, power - 1);
    }

    public static int getPower(BlockState state) {
        if (state.hasProperty((Property)ACHERUNE_POWER)) {
            return (Integer)state.getValue((Property)ACHERUNE_POWER);
        }
        if (state.is(MirthdewEncoreBlocks.GREATER_ACHERUNE)) {
            return state.getValue(GreaterAcheruneBlock.RUNE_STATE) == GreaterAcheruneBlock.RuneState.BOUND ? 32 : 0;
        }
        return 0;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if ((Integer)state.getValue((Property)ACHERUNE_POWER) > 0) {
            if (random.nextBoolean()) {
                level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + 1.0f + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.5, 0.0);
            }
            for (int i = 0; i < 3; ++i) {
                level.addParticle((ParticleOptions)MirthdewEncoreParticleTypes.BACCHENITE_GLIMMER, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + 1.0f + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), ((double)random.nextFloat() - 0.5) * 0.01, 0.1, ((double)random.nextFloat() - 0.5) * 0.01);
            }
        }
    }
}

