/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.entity.DreamspeckEntity;
import phanastrae.mirthdew_encore.entity.MirthdewEncoreEntityTypes;

public class DreamseedBlock
extends Block {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    protected static final VoxelShape SHAPE = Shapes.joinUnoptimized((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape)Block.box((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0), (BooleanOp)BooleanOp.OR);

    public DreamseedBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, LIT});
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).isFaceSturdy((BlockGetter)world, pos, Direction.UP);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        FluidState fluidState = world.getFluidState(pos);
        BlockState blockState = world.getBlockState(pos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(blockState.is(Blocks.SOUL_FIRE)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && !this.canLight(world, state, pos)) {
            return (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public boolean canLight(LevelAccessor world, BlockState state, BlockPos pos) {
        return world.getBlockState(pos.below()).is(BlockTags.SOUL_FIRE_BASE_BLOCKS) && (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && !world.isClientSide()) {
            world.levelEvent(null, 1009, pos, 0);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        DreamspeckEntity dreamspeckEntity;
        super.playerDestroy(world, player, pos, state, blockEntity, tool);
        if (!world.isClientSide && !EnchantmentHelper.hasTag((ItemStack)tool, (TagKey)EnchantmentTags.PREVENTS_DECORATED_POT_SHATTERING) && (dreamspeckEntity = (DreamspeckEntity)MirthdewEncoreEntityTypes.DREAMSPECK.create(world)) != null) {
            dreamspeckEntity.setPos(pos.getBottomCenter());
            world.addFreshEntity((Entity)dreamspeckEntity);
        }
    }

    protected void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (!entity.fireImmune()) {
                entity.setRemainingFireTicks(entity.getRemainingFireTicks() + 1);
                if (entity.getRemainingFireTicks() == 0) {
                    entity.igniteForSeconds(8.0f);
                }
            }
            entity.hurt(world.damageSources().inFire(), 2.0f);
        }
        super.entityInside(state, world, pos, entity);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() || !world.getBlockState(pos.below()).is(BlockTags.SOUL_FIRE_BASE_BLOCKS) || !player.getAbilities().mayBuild || !stack.is(Items.FLINT_AND_STEEL) && !stack.is(Items.FIRE_CHARGE)) {
            return super.useItemOn(stack, state, world, pos, player, hand, hit);
        }
        world.playSound(player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.4f + 0.8f);
        world.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 11);
        world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
        Item item = stack.getItem();
        if (stack.is(Items.FLINT_AND_STEEL)) {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        } else {
            stack.consume(1, (LivingEntity)player);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)item));
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            double z;
            double y;
            double x;
            int i;
            if (random.nextInt(24) == 0) {
                world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
            }
            if (random.nextInt(5) == 0) {
                world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.BLOCKS, 0.5f + random.nextFloat() * 0.2f, 0.3f + random.nextFloat() * 1.5f, false);
            }
            for (i = 0; i < 3; ++i) {
                x = (double)pos.getX() + random.nextDouble();
                y = (double)pos.getY() + random.nextDouble() * 0.5 + 0.5;
                z = (double)pos.getZ() + random.nextDouble();
                world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, x, y, z, 0.0, 0.0, 0.0);
            }
            for (i = 0; i < 12; ++i) {
                x = (double)pos.getX() + 0.1 + 0.8 * random.nextDouble();
                y = (double)pos.getY() + 1.2 * random.nextDouble();
                z = (double)pos.getZ() + 0.1 + 0.8 * random.nextDouble();
                world.addParticle((ParticleOptions)(i < 6 ? ParticleTypes.WITCH : ParticleTypes.ENCHANT), x, y, z, 0.0, 3.0, 0.0);
            }
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

