/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.block.entity.GreaterAcheruneBlockEntity;
import phanastrae.mirthdew_encore.block.entity.MirthdewEncoreBlockEntityTypes;
import phanastrae.mirthdew_encore.component.MirthdewEncoreDataComponentTypes;
import phanastrae.mirthdew_encore.component.type.LinkedAcheruneComponent;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlStageManager;
import phanastrae.mirthdew_encore.dreamtwirl.stage.DreamtwirlStage;
import phanastrae.mirthdew_encore.dreamtwirl.stage.acherune.Acherune;
import phanastrae.mirthdew_encore.item.MirthdewEncoreItems;
import phanastrae.mirthdew_encore.particle.MirthdewEncoreParticleTypes;

public class GreaterAcheruneBlock
extends BaseEntityBlock {
    public static final EnumProperty<RuneState> RUNE_STATE = EnumProperty.create((String)"rune_state", RuneState.class);
    public static final MapCodec<GreaterAcheruneBlock> CODEC = GreaterAcheruneBlock.simpleCodec(GreaterAcheruneBlock::new);

    public MapCodec<GreaterAcheruneBlock> codec() {
        return CODEC;
    }

    protected GreaterAcheruneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(RUNE_STATE, (Comparable)((Object)RuneState.INERT)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RUNE_STATE});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GreaterAcheruneBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return GreaterAcheruneBlock.createTickerHelper(type, MirthdewEncoreBlockEntityTypes.GREATER_ACHERUNE, (BlockEntityTicker)(level.isClientSide() ? GreaterAcheruneBlockEntity::tickClient : GreaterAcheruneBlockEntity::tickServer));
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GreaterAcheruneBlockEntity) {
            GreaterAcheruneBlockEntity gabe = (GreaterAcheruneBlockEntity)blockEntity;
            gabe.onPlace(state, level, pos, oldState);
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof GreaterAcheruneBlockEntity) {
            GreaterAcheruneBlockEntity gabe = (GreaterAcheruneBlockEntity)blockEntity;
            gabe.onRemove(state, level, pos, newState);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (state.getValue(RUNE_STATE) != RuneState.INERT && stack.is(Items.ENDER_EYE)) {
            Acherune acherune;
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            DreamtwirlStage stage = DreamtwirlStageManager.getStage(level, pos);
            if (stage != null && (acherune = stage.getStageAcherunes().getAcherune(pos)) != null) {
                ItemStack newStack = MirthdewEncoreItems.SLEEPY_EYE.getDefaultInstance();
                newStack.applyComponentsAndValidate(stack.getComponentsPatch());
                newStack.set(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE, (Object)LinkedAcheruneComponent.fromAcheruneAndStage(stage, acherune));
                stack.consume(1, (LivingEntity)player);
                if (!player.getInventory().add(newStack.copy())) {
                    player.drop(newStack, false);
                }
                return ItemInteractionResult.CONSUME;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (state.getValue(RUNE_STATE) == RuneState.BOUND) {
            if (random.nextBoolean()) {
                level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + 1.0f + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.5, 0.0);
            }
            for (int i = 0; i < 3; ++i) {
                level.addParticle((ParticleOptions)MirthdewEncoreParticleTypes.BACCHENITE_GLIMMER, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + 1.0f + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), ((double)random.nextFloat() - 0.5) * 0.01, 0.1, ((double)random.nextFloat() - 0.5) * 0.01);
            }
        }
    }

    public static enum RuneState implements StringRepresentable
    {
        INERT("inert"),
        UNBOUND("unbound"),
        BOUND("bound");

        String name;

        private RuneState(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

