/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import phanastrae.mirthdew_encore.block.MirthdewEncoreBlocks;

public class LychetherBlock
extends TransparentBlock {
    public static final MapCodec<LychetherBlock> CODEC = LychetherBlock.simpleCodec(LychetherBlock::new);
    public static final BooleanProperty DISSOLVING = BooleanProperty.create((String)"dissolving");

    protected MapCodec<? extends TransparentBlock> codec() {
        return CODEC;
    }

    public LychetherBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISSOLVING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISSOLVING});
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean dissolving = (Boolean)state.getValue((Property)DISSOLVING);
        if (dissolving) {
            level.destroyBlock(pos, false);
            level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 1.5f, 0.8f + random.nextFloat() * 0.5f);
            LychetherBlock.dissolveAdjacentLychether((Level)level, pos, random);
        }
    }

    public static void dissolveAdjacentLychether(Level level, BlockPos pos, RandomSource random) {
        for (Direction direction : Direction.values()) {
            boolean adjDissolving;
            BlockPos adjPos = pos.relative(direction);
            BlockState adjState = level.getBlockState(adjPos);
            if (!adjState.is(MirthdewEncoreBlocks.LYCHETHER) || !adjState.hasProperty((Property)DISSOLVING) || (adjDissolving = ((Boolean)adjState.getValue((Property)DISSOLVING)).booleanValue())) continue;
            level.setBlockAndUpdate(adjPos, (BlockState)adjState.setValue((Property)DISSOLVING, (Comparable)Boolean.valueOf(true)));
            level.scheduleTick(adjPos, adjState.getBlock(), 3 + random.nextInt(7));
        }
    }
}

