/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.block.entity.LychsealBlockEntity;
import phanastrae.mirthdew_encore.block.entity.MirthdewEncoreBlockEntityTypes;

public class LychsealBlock
extends BaseEntityBlock {
    public static final MapCodec<LychsealBlock> CODEC = LychsealBlock.simpleCodec(LychsealBlock::new);
    public static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.ORIENTATION;

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public LychsealBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(ORIENTATION, (Comparable)FrontAndTop.NORTH_UP));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ORIENTATION});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LychsealBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return LychsealBlock.createTickerHelper(type, MirthdewEncoreBlockEntityTypes.LYCHSEAL, (BlockEntityTicker)(level.isClientSide() ? LychsealBlockEntity::tickClient : LychsealBlockEntity::tickServer));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction frontDirection = context.getClickedFace();
        Direction topDirection = frontDirection.getAxis() == Direction.Axis.Y ? context.getHorizontalDirection().getOpposite() : Direction.UP;
        return (BlockState)this.defaultBlockState().setValue(ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)frontDirection, (Direction)topDirection));
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(ORIENTATION, (Comparable)rotation.rotation().rotate((FrontAndTop)state.getValue(ORIENTATION)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue(ORIENTATION, (Comparable)mirror.rotation().rotate((FrontAndTop)state.getValue(ORIENTATION)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LychsealBlockEntity) {
            LychsealBlockEntity lychsealBlockEntity = (LychsealBlockEntity)blockEntity;
            lychsealBlockEntity.open(level, pos, state);
            return InteractionResult.CONSUME;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }
}

