/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.block.MirthdewEncoreBlocks;
import phanastrae.mirthdew_encore.block.SlumberveilBlock;
import phanastrae.mirthdew_encore.block.entity.MirthdewEncoreBlockEntityTypes;
import phanastrae.mirthdew_encore.block.entity.SlumbersocketBlockEntity;
import phanastrae.mirthdew_encore.item.MirthdewEncoreItems;
import phanastrae.mirthdew_encore.item.SlumberingEyeItem;

public class SlumbersocketBlock
extends BaseEntityBlock {
    public static final MapCodec<SlumbersocketBlock> CODEC = SlumbersocketBlock.simpleCodec(SlumbersocketBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty DREAMING = BooleanProperty.create((String)"dreaming");

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public SlumbersocketBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)DREAMING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, DREAMING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        world.scheduleTick(pos, (Block)this, 4);
        super.setPlacedBy(world, pos, state, placer, itemStack);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        world.scheduleTick(pos, (Block)this, 4);
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof SlumbersocketBlockEntity) {
                SlumbersocketBlockEntity slumberSocketBlockEntity = (SlumbersocketBlockEntity)blockEntity;
                slumberSocketBlockEntity.damageEye();
                Containers.dropContents((Level)world, (BlockPos)pos, slumberSocketBlockEntity.getItems());
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        world.scheduleTick(pos, (Block)this, 4);
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos downPos;
        BlockState downState;
        if (((Boolean)state.getValue((Property)DREAMING)).booleanValue() && (downState = world.getBlockState(downPos = pos.below())).isAir()) {
            world.setBlockAndUpdate(downPos, (BlockState)((BlockState)((BlockState)MirthdewEncoreBlocks.SLUMBERVEIL.defaultBlockState().setValue((Property)SlumberveilBlock.DISTANCE, (Comparable)Integer.valueOf(0))).setValue((Property)SlumberveilBlock.SUPPORTING, (Comparable)Boolean.valueOf(true))).setValue(SlumberveilBlock.AXIS, (Comparable)((Direction)state.getValue((Property)FACING)).getClockWise().getAxis()));
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SlumbersocketBlockEntity) {
            SlumbersocketBlockEntity slumberSocketBlockEntity = (SlumbersocketBlockEntity)blockEntity;
            ItemStack itemStack = player.getItemInHand(hand);
            if (!slumberSocketBlockEntity.isHoldingItem()) {
                if (itemStack.is(Items.ENDER_EYE) || (itemStack.is(MirthdewEncoreItems.SLEEPY_EYE) || itemStack.is(MirthdewEncoreItems.SLUMBERING_EYE)) && SlumberingEyeItem.eyeHasDestination(itemStack)) {
                    if (!level.isClientSide) {
                        level.playSound(null, pos, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
                        player.gameEvent((Holder)GameEvent.BLOCK_PLACE, (Entity)player);
                        ItemStack newStack = itemStack.copyWithCount(1);
                        itemStack.consume(1, (LivingEntity)player);
                        slumberSocketBlockEntity.setHeldItem(newStack);
                        slumberSocketBlockEntity.checkAcherune(level, pos);
                        slumberSocketBlockEntity.checkDreaming(level, pos, state);
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            slumberSocketBlockEntity.markForUpdate(serverLevel);
                        }
                        return ItemInteractionResult.SUCCESS;
                    }
                    slumberSocketBlockEntity.setDefaultLookTarget(state);
                    return ItemInteractionResult.CONSUME;
                }
            } else if (itemStack.is(MirthdewEncoreItems.OCULAR_SOPORSTEW) && slumberSocketBlockEntity.canRepairEye()) {
                if (!level.isClientSide) {
                    level.playSound(null, pos, SoundEvents.ENDERMAN_SCREAM, SoundSource.BLOCKS, 0.8f, 0.8f + level.getRandom().nextFloat() * 0.4f);
                    player.gameEvent((Holder)GameEvent.BLOCK_CHANGE, (Entity)player);
                    itemStack.consume(1, (LivingEntity)player);
                    slumberSocketBlockEntity.repairEye();
                    slumberSocketBlockEntity.checkAcherune(level, pos);
                    slumberSocketBlockEntity.checkDreaming(level, pos, state);
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.CONSUME;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SlumbersocketBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return SlumbersocketBlock.createTickerHelper(type, MirthdewEncoreBlockEntityTypes.SLUMBERSOCKET, (BlockEntityTicker)(level.isClientSide() ? SlumbersocketBlockEntity::tickClient : SlumbersocketBlockEntity::tickServer));
    }
}

