/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.block;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.block.MirthdewEncoreBlocks;
import phanastrae.mirthdew_encore.block.SlumbersocketBlock;
import phanastrae.mirthdew_encore.block.entity.MirthdewEncoreBlockEntityTypes;
import phanastrae.mirthdew_encore.block.entity.SlumbersocketBlockEntity;
import phanastrae.mirthdew_encore.component.MirthdewEncoreDataComponentTypes;
import phanastrae.mirthdew_encore.component.type.LinkedAcheruneComponent;
import phanastrae.mirthdew_encore.component.type.LocationComponent;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlStageManager;
import phanastrae.mirthdew_encore.dreamtwirl.stage.DreamtwirlStage;
import phanastrae.mirthdew_encore.dreamtwirl.stage.acherune.Acherune;
import phanastrae.mirthdew_encore.util.RegionPos;

public class SlumberveilBlock
extends Block
implements Portal {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final BooleanProperty SUPPORTING = BooleanProperty.create((String)"supporting");
    public static final IntegerProperty DISTANCE = IntegerProperty.create((String)"distance", (int)0, (int)15);
    protected static final VoxelShape X_SHAPE = Block.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape Z_SHAPE = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);

    public SlumberveilBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)SUPPORTING, (Comparable)Boolean.valueOf(false))).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, SUPPORTING, DISTANCE});
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Z: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return ItemStack.EMPTY;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.getValue(AXIS)) {
            case Direction.Axis.Z -> Z_SHAPE;
            default -> X_SHAPE;
        };
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        for (int i = 0; i < 5; ++i) {
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() + random.nextDouble();
            double z = (double)pos.getZ() + random.nextDouble();
            double ox = ((double)random.nextFloat() - 0.5) * 0.5;
            double oy = ((double)random.nextFloat() - 0.5) * 0.5;
            double oz = ((double)random.nextFloat() - 0.5) * 0.5;
            int r = random.nextInt(2) * 2 - 1;
            if (axis == Direction.Axis.X) {
                x = (double)pos.getX() + 0.5 + 0.25 * (double)r;
                ox = random.nextFloat() * 2.0f * (float)r;
            } else {
                z = (double)pos.getZ() + 0.5 + 0.25 * (double)r;
                oz = random.nextFloat() * 2.0f * (float)r;
            }
            world.addParticle((ParticleOptions)(i == 0 ? ParticleTypes.WITCH : ParticleTypes.ENCHANT), x, y, z, ox, oy, oz);
        }
    }

    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        world.scheduleTick(pos, (Block)this, 2 + world.getRandom().nextInt(3));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        world.scheduleTick(pos, (Block)this, 2 + world.getRandom().nextInt(3));
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        boolean blockBroken = this.updateBlock(state, world, pos);
        if (!blockBroken) {
            this.spreadVeil(state, world, pos);
        }
    }

    public boolean updateBlock(BlockState state, ServerLevel world, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        boolean supporting = (Boolean)state.getValue((Property)SUPPORTING);
        int distance = (Integer)state.getValue((Property)DISTANCE);
        BlockPos upPos = pos.above();
        if (!supporting) {
            BlockState supportState = world.getBlockState(upPos);
            if (supportState.is((Block)this) && axis == supportState.getValue(AXIS)) {
                int targetDistance;
                boolean supporting2 = (Boolean)supportState.getValue((Property)SUPPORTING);
                int n = targetDistance = supporting2 ? 0 : (Integer)supportState.getValue((Property)DISTANCE) + 1;
                if (distance == targetDistance) {
                    return false;
                }
                distance = targetDistance;
                if (distance <= 15) {
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(distance)));
                    return false;
                }
            }
            world.destroyBlock(pos, false);
            return true;
        }
        BlockState supportState = world.getBlockState(upPos);
        if (supportState.is(MirthdewEncoreBlocks.SLUMBERSOCKET) && ((Boolean)supportState.getValue((Property)SlumbersocketBlock.DREAMING)).booleanValue()) {
            if (distance != 0) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(0)));
            }
            return false;
        }
        if (Block.canSupportCenter((LevelReader)world, (BlockPos)upPos, (Direction)Direction.DOWN)) {
            int minNeighborDistance = 15;
            for (Direction direction : Direction.values()) {
                int neighborDistance;
                BlockState neighborState;
                Direction.Axis axis2 = direction.getAxis();
                if (axis2.isVertical() || axis != axis2 || !(neighborState = world.getBlockState(pos.relative(direction))).is((Block)this) || !((Boolean)neighborState.getValue((Property)SUPPORTING)).booleanValue() || (neighborDistance = ((Integer)neighborState.getValue((Property)DISTANCE)).intValue()) >= minNeighborDistance) continue;
                minNeighborDistance = neighborDistance;
            }
            if (distance == minNeighborDistance + 1) {
                return false;
            }
        }
        world.destroyBlock(pos, false);
        return true;
    }

    public void spreadVeil(BlockState state, ServerLevel world, BlockPos pos) {
        BlockPos downPos;
        BlockState downState;
        int distance = (Integer)state.getValue((Property)DISTANCE);
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        boolean supporting = (Boolean)state.getValue((Property)SUPPORTING);
        if (supporting && distance <= 14) {
            for (Direction direction : Direction.values()) {
                BlockPos pos2;
                BlockState neighborState;
                Direction.Axis axis2 = direction.getAxis();
                if (axis2.isVertical() || axis != axis2 || (neighborState = world.getBlockState(pos2 = pos.relative(direction))).is((Block)this) || !neighborState.isAir() || !Block.canSupportCenter((LevelReader)world, (BlockPos)pos2.relative(Direction.UP), (Direction)Direction.DOWN)) continue;
                world.setBlockAndUpdate(pos2, (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(distance + 1)));
            }
        }
        if ((supporting || distance <= 14) && !(downState = world.getBlockState(downPos = pos.below())).is((Block)this) && downState.isAir()) {
            int targetDistance = supporting ? 0 : distance + 1;
            world.setBlockAndUpdate(downPos, (BlockState)((BlockState)state.setValue((Property)SUPPORTING, (Comparable)Boolean.valueOf(false))).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(targetDistance)));
        }
    }

    protected void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity.canUsePortal(false)) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
        super.entityInside(state, world, pos, entity);
    }

    public Portal.Transition getLocalTransition() {
        return Portal.Transition.CONFUSION;
    }

    public int getPortalTransitionTime(ServerLevel world, Entity entity) {
        int n;
        if (entity instanceof Player) {
            Player playerEntity = (Player)entity;
            n = Math.max(1, world.getGameRules().getInt(playerEntity.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
        } else {
            n = 0;
        }
        return n;
    }

    @Nullable
    public DimensionTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        Optional<SlumbersocketBlockEntity> slumbersocketBlockEntityOptional = this.findVeilSocket((Level)level, pos);
        if (slumbersocketBlockEntityOptional.isPresent()) {
            SlumbersocketBlockEntity slumbersocketBlockEntity = slumbersocketBlockEntityOptional.get();
            slumbersocketBlockEntity.checkAcherune((Level)level, slumbersocketBlockEntity.getBlockPos());
            ItemStack itemStack = slumbersocketBlockEntity.getHeldItem();
            if (!itemStack.isEmpty()) {
                LinkedAcheruneComponent linkedAcherune;
                Acherune acherune;
                Vec3 targetPos = null;
                Level targetWorld = null;
                if (itemStack.has(MirthdewEncoreDataComponentTypes.LOCATION_COMPONENT)) {
                    LocationComponent locationComponent = (LocationComponent)itemStack.get(MirthdewEncoreDataComponentTypes.LOCATION_COMPONENT);
                    targetPos = locationComponent.getPos();
                    targetWorld = locationComponent.getLevel(level.getServer());
                } else if (itemStack.has(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE) && (acherune = (linkedAcherune = (LinkedAcheruneComponent)itemStack.get(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE)).getAcherune(level.getServer())) != null) {
                    targetPos = acherune.getPos().above().getBottomCenter();
                    targetWorld = linkedAcherune.getLevel(level.getServer());
                }
                if (targetPos != null && targetWorld != null) {
                    DreamtwirlStage stage;
                    boolean validTarget = true;
                    DreamtwirlStageManager dreamtwirlStageManager = DreamtwirlStageManager.getDreamtwirlStageManager(targetWorld);
                    if (dreamtwirlStageManager != null && ((stage = dreamtwirlStageManager.getDreamtwirlIfPresent(RegionPos.fromVec3(targetPos))) == null || stage.isDeletingSelf())) {
                        validTarget = false;
                    }
                    if (validTarget && targetWorld instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)targetWorld;
                        return new DimensionTransition(serverWorld, targetPos, entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET));
                    }
                }
            }
        }
        return null;
    }

    public Optional<SlumbersocketBlockEntity> findVeilSocket(Level world, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.set((Vec3i)pos);
        BlockState state = world.getBlockState(pos);
        if (!state.hasProperty((Property)SUPPORTING) || !state.hasProperty((Property)DISTANCE)) {
            return Optional.empty();
        }
        int distance = (Integer)state.getValue((Property)DISTANCE);
        boolean supporting = (Boolean)state.getValue((Property)SUPPORTING);
        if (!supporting) {
            for (int i = 0; i < distance + 1; ++i) {
                mutable.setWithOffset((Vec3i)mutable, 0, 1, 0);
                if (world.getBlockState((BlockPos)mutable).is((Block)this)) continue;
                mutable.setWithOffset((Vec3i)mutable, 0, -1, 0);
                break;
            }
        }
        if (!(state = world.getBlockState((BlockPos)mutable)).hasProperty((Property)DISTANCE)) {
            return Optional.empty();
        }
        distance = (Integer)state.getValue((Property)DISTANCE);
        block1: for (int j = 0; j < 15; ++j) {
            for (Direction direction : Direction.values()) {
                int adjDistance;
                mutable.setWithOffset((Vec3i)mutable, direction);
                BlockState adjState = world.getBlockState((BlockPos)mutable);
                if (adjState.is((Block)this) && ((Boolean)adjState.getValue((Property)SUPPORTING)).booleanValue() && (adjDistance = ((Integer)adjState.getValue((Property)DISTANCE)).intValue()) < distance) {
                    distance = adjDistance;
                    continue block1;
                }
                mutable.setWithOffset((Vec3i)mutable, direction.getOpposite());
            }
        }
        mutable.setWithOffset((Vec3i)mutable, 0, 1, 0);
        BlockState socketState = world.getBlockState((BlockPos)mutable);
        if (socketState.is(MirthdewEncoreBlocks.SLUMBERSOCKET) && ((Boolean)socketState.getValue((Property)SlumbersocketBlock.DREAMING)).booleanValue()) {
            return world.getBlockEntity((BlockPos)mutable, MirthdewEncoreBlockEntityTypes.SLUMBERSOCKET);
        }
        return Optional.empty();
    }

    protected boolean skipRendering(BlockState state, BlockState adjacentState, Direction direction) {
        return adjacentState.is((Block)this) || super.skipRendering(state, adjacentState, direction);
    }
}

