/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import phanastrae.mirthdew_encore.block.MirthdewEncoreBlocks;
import phanastrae.mirthdew_encore.particle.MirthdewEncoreParticleTypes;

public class SunfleckedScarabrimBlock
extends Block {
    public static final MapCodec<SunfleckedScarabrimBlock> CODEC = SunfleckedScarabrimBlock.simpleCodec(SunfleckedScarabrimBlock::new);

    public MapCodec<SunfleckedScarabrimBlock> codec() {
        return CODEC;
    }

    protected SunfleckedScarabrimBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean canBeSunflecked(BlockState state, LevelReader reader, BlockPos pos) {
        BlockPos blockpos = pos.above();
        BlockState blockstate = reader.getBlockState(blockpos);
        int i = LightEngine.getLightBlockInto((BlockGetter)reader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.getLightBlock((BlockGetter)reader, blockpos));
        return i < reader.getMaxLightLevel();
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!SunfleckedScarabrimBlock.canBeSunflecked(state, (LevelReader)level, pos)) {
            level.setBlockAndUpdate(pos, MirthdewEncoreBlocks.SCARABRIM.defaultBlockState());
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockPos blockpos;
        BlockState blockstate;
        super.animateTick(state, level, pos, random);
        if (random.nextInt(7) == 0 && !SunfleckedScarabrimBlock.isFaceFull((VoxelShape)(blockstate = level.getBlockState(blockpos = pos.above())).getCollisionShape((BlockGetter)level, blockpos), (Direction)Direction.DOWN)) {
            ParticleUtils.spawnParticleOnFace((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ParticleOptions)MirthdewEncoreParticleTypes.SUNFLECK, (Vec3)new Vec3(0.0, 0.2, 0.0), (double)0.5);
        }
    }
}

