/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.block.entity.MirthdewEncoreBlockEntityTypes;
import phanastrae.mirthdew_encore.block.entity.VericDreamsnareBlockEntity;

public class VericDreamsnareBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<VericDreamsnareBlock> CODEC = VericDreamsnareBlock.simpleCodec(VericDreamsnareBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape[] SHAPES = VericDreamsnareBlock.getShapes();
    protected static final VoxelShape[] SHAPES_WITH_ITEM = VericDreamsnareBlock.getShapesWithItem();

    private static VoxelShape[] getShapes() {
        VoxelShape[] shapes = new VoxelShape[]{Block.box((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), Block.box((double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0, (double)16.0), Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)3.0), Block.box((double)13.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), Block.box((double)0.0, (double)1.0, (double)1.0, (double)3.0, (double)15.0, (double)15.0)};
        return shapes;
    }

    private static VoxelShape[] getShapesWithItem() {
        VoxelShape ITEM_SHAPE = Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
        VoxelShape[] shapes = new VoxelShape[6];
        for (int i = 0; i < 6; ++i) {
            shapes[i] = Shapes.joinUnoptimized((VoxelShape)SHAPES[i], (VoxelShape)ITEM_SHAPE, (BooleanOp)BooleanOp.OR);
        }
        return shapes;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VericDreamsnareBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockPos = pos.relative(direction.getOpposite());
        return world.getBlockState(blockPos).isFaceSturdy((BlockGetter)world, blockPos, direction);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        FluidState fluidState = ctx.getLevel().getFluidState(blockPos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER))).setValue((Property)FACING, (Comparable)ctx.getClickedFace());
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        Direction stateDirection;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return (stateDirection = (Direction)state.getValue((Property)FACING)).getOpposite() == direction && !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VericDreamsnareBlockEntity vericDreamsnareBlockEntity;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof VericDreamsnareBlockEntity && (vericDreamsnareBlockEntity = (VericDreamsnareBlockEntity)blockEntity).isHoldingItem()) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            return SHAPES_WITH_ITEM[direction.get3DDataValue()];
        }
        return this.getCollisionShape(state, world, pos, context);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return SHAPES[direction.get3DDataValue()];
    }

    protected void spawnAfterBreak(BlockState state, ServerLevel world, BlockPos pos, ItemStack tool, boolean dropExperience) {
        super.spawnAfterBreak(state, world, pos, tool, dropExperience);
        if (dropExperience) {
            this.tryDropExperience(world, pos, tool, (IntProvider)ConstantInt.of((int)5));
        }
    }

    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof VericDreamsnareBlockEntity) {
                VericDreamsnareBlockEntity vericDreamsnareBlockEntity = (VericDreamsnareBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, vericDreamsnareBlockEntity.getItems());
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack;
        VericDreamsnareBlockEntity vericDreamsnareBlockEntity;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof VericDreamsnareBlockEntity && (vericDreamsnareBlockEntity = (VericDreamsnareBlockEntity)blockEntity).isHoldingItem() && (itemStack = player.getItemInHand(hand)).is(Items.SHEARS)) {
            if (!world.isClientSide) {
                player.level().playSound(null, (Entity)player, SoundEvents.BOGGED_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                Containers.dropContents((Level)world, (BlockPos)pos, vericDreamsnareBlockEntity.getItems());
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        VericDreamsnareBlockEntity vericDreamsnareBlockEntity;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof VericDreamsnareBlockEntity && (vericDreamsnareBlockEntity = (VericDreamsnareBlockEntity)blockEntity).isHoldingItem()) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            Vec3 snareBaseOffset = vericDreamsnareBlockEntity.getBaseOffset();
            for (int i = 0; i < 12; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + snareBaseOffset.x + ((double)random.nextFloat() - 0.5) * 0.6, (double)pos.getY() + snareBaseOffset.y + ((double)random.nextFloat() - 0.5) * 0.6, (double)pos.getZ() + snareBaseOffset.z + ((double)random.nextFloat() - 0.5) * 0.6, (double)direction.getStepX() * 0.8 + 0.2 * ((double)random.nextFloat() - 0.5), (double)direction.getStepY() * 0.8 + 0.2 * ((double)random.nextFloat() - 0.5), (double)direction.getStepZ() * 0.8 + 0.2 * ((double)random.nextFloat() - 0.5));
            }
        }
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new VericDreamsnareBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return BaseEntityBlock.createTickerHelper(type, MirthdewEncoreBlockEntityTypes.VERIC_DREAMSNARE, VericDreamsnareBlockEntity::tick);
    }
}

