/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.block.CustomLiquidBlock;

public class VesperbileLiquidBlock
extends CustomLiquidBlock {
    public static final BooleanProperty EMITS_LIGHT = BooleanProperty.create((String)"emits_light");

    protected VesperbileLiquidBlock(FlowingFluid fluid, BlockBehaviour.Properties properties) {
        super(fluid, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)EMITS_LIGHT, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{EMITS_LIGHT});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            state = VesperbileLiquidBlock.updateEmitsLight(state, context.getClickedPos(), (LevelAccessor)context.getLevel());
        }
        return state;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return VesperbileLiquidBlock.updateEmitsLight(super.updateShape(state, facing, facingState, level, currentPos, facingPos), currentPos, level);
    }

    public static BlockState updateEmitsLight(BlockState state, BlockPos pos, LevelAccessor level) {
        return (BlockState)state.setValue((Property)EMITS_LIGHT, (Comparable)Boolean.valueOf(VesperbileLiquidBlock.shouldEmitLight(state, pos, level)));
    }

    public static boolean shouldEmitLight(BlockState state, BlockPos pos, LevelAccessor level) {
        for (Direction direction : Direction.values()) {
            BlockPos adjPos = pos.relative(direction);
            BlockState adjState = level.getBlockState(adjPos);
            if (!VesperbileLiquidBlock.emitLightForAdjState(adjState, level, adjPos, direction)) continue;
            return true;
        }
        return false;
    }

    public static boolean emitLightForAdjState(BlockState adjState, LevelAccessor level, BlockPos adjPos, Direction direction) {
        return adjState.getFluidState().isEmpty() && !adjState.isFaceSturdy((BlockGetter)level, adjPos, direction.getOpposite());
    }
}

