/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.block.GreaterAcheruneBlock;
import phanastrae.mirthdew_encore.block.entity.MirthdewEncoreBlockEntityTypes;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlStageManager;
import phanastrae.mirthdew_encore.dreamtwirl.stage.DreamtwirlStage;
import phanastrae.mirthdew_encore.dreamtwirl.stage.acherune.Acherune;
import phanastrae.mirthdew_encore.dreamtwirl.stage.acherune.StageAcherunes;
import phanastrae.mirthdew_encore.util.BlockPosDimensional;

public class GreaterAcheruneBlockEntity
extends BlockEntity {
    @Nullable
    private Acherune acherune = null;
    private boolean hasLink;

    public GreaterAcheruneBlockEntity(BlockPos pos, BlockState blockState) {
        super(MirthdewEncoreBlockEntityTypes.GREATER_ACHERUNE, pos, blockState);
        this.hasLink = blockState.getValue(GreaterAcheruneBlock.RUNE_STATE) == GreaterAcheruneBlock.RuneState.BOUND;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState) {
        this.createIfNeeded(state, level, pos);
    }

    public void createIfNeeded(BlockState state, Level level, BlockPos pos) {
        DreamtwirlStage stage;
        if (this.acherune == null && (stage = DreamtwirlStageManager.getStage(level, pos)) != null) {
            StageAcherunes stageAcherunes = stage.getStageAcherunes();
            Acherune ac = stageAcherunes.getAcherune(pos);
            if (ac == null) {
                ac = stageAcherunes.create(pos, level);
            }
            if (ac != null) {
                this.acherune = ac;
                level.setBlock(pos, (BlockState)state.setValue(GreaterAcheruneBlock.RUNE_STATE, (Comparable)((Object)(ac.getLinkedPos() == null ? GreaterAcheruneBlock.RuneState.UNBOUND : GreaterAcheruneBlock.RuneState.BOUND))), 3);
            }
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState) {
        DreamtwirlStage stage = DreamtwirlStageManager.getStage(level, pos);
        if (stage != null) {
            StageAcherunes stageAcherunes = stage.getStageAcherunes();
            stageAcherunes.remove(pos);
        }
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, GreaterAcheruneBlockEntity blockEntity) {
        if (state.getValue(GreaterAcheruneBlock.RUNE_STATE) == GreaterAcheruneBlock.RuneState.BOUND) {
            RandomSource random = level.getRandom();
            level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + 1.0f + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.5, 0.0);
        }
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, GreaterAcheruneBlockEntity blockEntity) {
        blockEntity.createIfNeeded(state, level, pos);
        if (blockEntity.acherune != null) {
            BlockPosDimensional bpd = blockEntity.acherune.getLinkedPos();
            boolean nowHasLink = bpd != null;
            boolean hadLink = blockEntity.hasLink;
            if (nowHasLink && !hadLink) {
                level.setBlock(pos, (BlockState)state.setValue(GreaterAcheruneBlock.RUNE_STATE, (Comparable)((Object)GreaterAcheruneBlock.RuneState.BOUND)), 3);
                blockEntity.hasLink = false;
            } else if (!nowHasLink && hadLink) {
                level.setBlock(pos, (BlockState)state.setValue(GreaterAcheruneBlock.RUNE_STATE, (Comparable)((Object)GreaterAcheruneBlock.RuneState.UNBOUND)), 3);
                blockEntity.hasLink = true;
            }
        }
    }
}

