/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.block.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import phanastrae.mirthdew_encore.block.DreamseedBlock;
import phanastrae.mirthdew_encore.block.MirthdewEncoreBlocks;
import phanastrae.mirthdew_encore.block.SlumbersocketBlock;
import phanastrae.mirthdew_encore.block.entity.MirthdewEncoreBlockEntityTypes;
import phanastrae.mirthdew_encore.component.MirthdewEncoreDataComponentTypes;
import phanastrae.mirthdew_encore.component.type.LinkedAcheruneComponent;
import phanastrae.mirthdew_encore.component.type.LinkedDreamtwirlComponent;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlStageManager;
import phanastrae.mirthdew_encore.dreamtwirl.stage.DreamtwirlStage;
import phanastrae.mirthdew_encore.dreamtwirl.stage.acherune.Acherune;
import phanastrae.mirthdew_encore.item.MirthdewEncoreItems;
import phanastrae.mirthdew_encore.item.SlumberingEyeItem;
import phanastrae.mirthdew_encore.util.BlockPosDimensional;

public class SlumbersocketBlockEntity
extends BlockEntity {
    float targetYaw;
    float targetPitch;
    public float yaw;
    public float pitch;
    public float prevYaw;
    public float prevPitch;
    public long timer = 0L;
    private final NonNullList<ItemStack> heldItem = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private boolean checkedAcherune = false;
    @Nullable
    private Acherune linkedAcherune;
    private boolean checkedDreaming = false;
    private boolean wasDreaming;

    public SlumbersocketBlockEntity(BlockPos pos, BlockState state) {
        super(MirthdewEncoreBlockEntityTypes.SLUMBERSOCKET, pos, state);
        this.setDefaultLookTarget(state);
        this.pitch = this.targetPitch;
        this.yaw = this.targetYaw;
        this.prevPitch = this.targetPitch;
        this.prevYaw = this.targetYaw;
        this.wasDreaming = state.hasProperty((Property)SlumbersocketBlock.DREAMING) ? (Boolean)state.getValue((Property)SlumbersocketBlock.DREAMING) : false;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.heldItem, (boolean)true, (HolderLookup.Provider)registryLookup);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.heldItem.clear();
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.heldItem, (HolderLookup.Provider)registryLookup);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag nbtCompound = this.saveCustomOnly(registryLookup);
        return nbtCompound;
    }

    public void setHeldItem(ItemStack itemStack) {
        this.heldItem.set(0, (Object)itemStack);
        this.setChanged();
        this.checkedAcherune = false;
        this.checkedDreaming = false;
    }

    public ItemStack getHeldItem() {
        return (ItemStack)this.heldItem.getFirst();
    }

    public boolean isHoldingItem() {
        return !this.getHeldItem().isEmpty();
    }

    public NonNullList<ItemStack> getItems() {
        return this.heldItem;
    }

    public void setDefaultLookTarget(BlockState state) {
        Direction direction = state.hasProperty((Property)HorizontalDirectionalBlock.FACING) ? (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING) : Direction.NORTH;
        this.targetYaw = direction.toYRot();
        this.targetPitch = 0.0f;
    }

    public void markForUpdate(ServerLevel level) {
        level.getChunkSource().blockChanged(this.getBlockPos());
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, SlumbersocketBlockEntity blockEntity) {
        double z;
        double y;
        double x = (double)pos.getX() + 0.5;
        Player playerEntity = level.getNearestPlayer(x, y = (double)pos.getY() + 0.5, z = (double)pos.getZ() + 0.5, 16.0, false);
        if (playerEntity != null) {
            Vec3 offset = playerEntity.getEyePosition().subtract(x, y, z).normalize();
            blockEntity.targetYaw = (float)Math.toDegrees((double)Mth.atan2((double)offset.z, (double)offset.x)) - 90.0f;
            blockEntity.targetPitch = (float)Math.toDegrees((double)Mth.atan2((double)offset.y, (double)offset.horizontalDistance()));
        } else {
            blockEntity.setDefaultLookTarget(state);
        }
        blockEntity.prevYaw = blockEntity.yaw;
        blockEntity.prevPitch = blockEntity.pitch;
        ItemStack heldItem = blockEntity.getHeldItem();
        float turnSpeed = 0.0f;
        if (heldItem.is(Items.ENDER_EYE)) {
            turnSpeed = 0.07f;
        } else if (heldItem.is(MirthdewEncoreItems.SLEEPY_EYE)) {
            turnSpeed = 0.03f;
        } else if (heldItem.is(MirthdewEncoreItems.SLUMBERING_EYE)) {
            turnSpeed = 0.015f;
        }
        blockEntity.yaw = Mth.rotLerp((float)turnSpeed, (float)blockEntity.yaw, (float)blockEntity.targetYaw);
        blockEntity.pitch = Mth.lerp((float)turnSpeed, (float)blockEntity.pitch, (float)blockEntity.targetPitch);
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, SlumbersocketBlockEntity blockEntity) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ++blockEntity.timer;
        if (!blockEntity.checkedAcherune) {
            blockEntity.checkAcherune(level, pos);
        }
        if (!blockEntity.checkedDreaming || !blockEntity.wasDreaming && blockEntity.timer % 100L == 0L) {
            blockEntity.checkDreaming(level, pos, state);
        }
        if (blockEntity.timer % 100L == 0L) {
            blockEntity.checkAcherune(level, pos);
            if (state.hasProperty((Property)SlumbersocketBlock.DREAMING)) {
                ItemStack heldItem = blockEntity.getHeldItem();
                if (!blockEntity.wasDreaming && heldItem.is(Items.ENDER_EYE) && level.getBlockState(pos.below()).isAir()) {
                    SlumbersocketBlockEntity.attemptEat(serverLevel, pos, state, blockEntity);
                }
                if (heldItem.has(MirthdewEncoreDataComponentTypes.LINKED_DREAMTWIRL) && !heldItem.has(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE)) {
                    SlumbersocketBlockEntity.attemptLinkToDreamtwirlSpawn(serverLevel, pos, state, blockEntity, heldItem);
                }
            }
        }
    }

    public void checkAcherune(Level level, BlockPos pos) {
        ItemStack eye = this.getHeldItem();
        if (eye.has(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE)) {
            LinkedAcheruneComponent lac = (LinkedAcheruneComponent)eye.get(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE);
            this.linkedAcherune = lac.getAcherune(level.getServer());
            if (this.linkedAcherune == null && (eye.is(MirthdewEncoreItems.SLEEPY_EYE) || eye.is(MirthdewEncoreItems.SLUMBERING_EYE))) {
                ItemStack itemStack = Items.ENDER_EYE.getDefaultInstance();
                itemStack.applyComponents(eye.getComponentsPatch());
                itemStack.remove(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE);
                this.setHeldItem(itemStack);
                Level level2 = this.getLevel();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    this.markForUpdate(serverLevel);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 50, 0.3, 0.3, 0.3, 0.1);
                    level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ENDERMAN_HURT, SoundSource.BLOCKS, 3.0f, 1.0f);
                }
            }
        } else {
            this.linkedAcherune = null;
        }
        this.checkedAcherune = true;
    }

    public void checkDreaming(Level level, BlockPos pos, BlockState state) {
        boolean dreaming = this.isDreaming(level, pos);
        if (!dreaming) {
            this.tryBindToAcherune(level, pos);
            dreaming = this.isDreaming(level, pos);
        }
        if (dreaming != this.wasDreaming && state.hasProperty((Property)SlumbersocketBlock.DREAMING)) {
            this.wasDreaming = dreaming;
            level.setBlock(pos, (BlockState)state.setValue((Property)SlumbersocketBlock.DREAMING, (Comparable)Boolean.valueOf(dreaming)), 3);
        }
        this.checkedDreaming = true;
    }

    public void tryBindToAcherune(Level level, BlockPos pos) {
        if (this.linkedAcherune != null && level instanceof ServerLevel) {
            DreamtwirlStage stage;
            LinkedAcheruneComponent lac;
            Level acLevel;
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack eye = this.getHeldItem();
            if (eye.is(MirthdewEncoreItems.SLUMBERING_EYE) && eye.has(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE) && (acLevel = (lac = (LinkedAcheruneComponent)eye.get(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE)).getLevel(serverLevel.getServer())) != null && (stage = DreamtwirlStageManager.getStage(acLevel, lac.regionId())) != null) {
                if (acLevel instanceof ServerLevel) {
                    ServerLevel acServerLevel = (ServerLevel)acLevel;
                    this.linkedAcherune.validateLinkedPos(acServerLevel.getServer(), stage.getStageAcherunes());
                }
                if (this.linkedAcherune.getLinkedPos() == null) {
                    this.linkedAcherune.setLinkedPos(BlockPosDimensional.fromPosAndLevel(pos, level));
                    stage.getStageAcherunes().setDirty();
                }
            }
        }
    }

    public BlockPos getTargetPos() {
        BlockPos socketPos = this.getBlockPos();
        Level level = this.getLevel();
        if (level == null) {
            return socketPos;
        }
        Optional blockPosOptional = BlockPos.findClosestMatch((BlockPos)socketPos, (int)24, (int)24, blockPos -> {
            BlockState checkState = level.getBlockState(blockPos);
            return checkState.is(MirthdewEncoreBlocks.WAKESIDE_RUNE);
        });
        if (blockPosOptional.isPresent()) {
            return ((BlockPos)blockPosOptional.get()).above();
        }
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)SlumbersocketBlock.FACING)) {
            int i;
            Direction direction = (Direction)state.getValue((Property)SlumbersocketBlock.FACING);
            BlockPos targetPos = socketPos;
            for (i = 0; i < 5; ++i) {
                BlockPos adjPos = targetPos.relative(direction);
                BlockState adjState = level.getBlockState(adjPos);
                if (!adjState.getCollisionShape((BlockGetter)level, adjPos).isEmpty()) continue;
                targetPos = adjPos;
            }
            for (i = 0; i < 48; ++i) {
                BlockPos downPos = targetPos.below();
                BlockState downState = level.getBlockState(downPos);
                if (!downState.getCollisionShape((BlockGetter)level, downPos).isEmpty()) continue;
                targetPos = downPos;
            }
            Optional blockPosOptional2 = BlockPos.findClosestMatch((BlockPos)targetPos, (int)24, (int)24, blockPos -> {
                BlockState checkState = level.getBlockState(blockPos);
                return checkState.is(MirthdewEncoreBlocks.WAKESIDE_RUNE);
            });
            if (blockPosOptional2.isPresent()) {
                return ((BlockPos)blockPosOptional2.get()).above();
            }
            return targetPos;
        }
        return socketPos;
    }

    public boolean isDreaming(Level level, BlockPos pos) {
        if (this.canDream()) {
            BlockState below = level.getBlockState(pos.below());
            return below.is(MirthdewEncoreBlocks.SLUMBERVEIL) || below.isAir();
        }
        return false;
    }

    public boolean canDream() {
        ItemStack eye = this.getHeldItem();
        if (!eye.is(MirthdewEncoreItems.SLUMBERING_EYE)) {
            return false;
        }
        if (eye.has(MirthdewEncoreDataComponentTypes.LOCATION_COMPONENT)) {
            return true;
        }
        return eye.has(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE) && this.linkedAcherune != null && this.linkedAcherune.isLinkedTo(this.getBlockPos(), this.getLevel());
    }

    public void damageEye() {
        this.setHeldItem(SlumberingEyeItem.damageEye(this.getHeldItem()));
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.markForUpdate(serverLevel);
        }
    }

    public boolean canRepairEye() {
        ItemStack heldItem = this.getHeldItem();
        return heldItem.is(MirthdewEncoreItems.SLEEPY_EYE) || heldItem.is(MirthdewEncoreItems.SLUMBERING_EYE) && heldItem.getDamageValue() != 0;
    }

    public boolean repairEye() {
        if (this.canRepairEye()) {
            this.setHeldItem(SlumberingEyeItem.repairEye(this.getHeldItem()));
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.markForUpdate(serverLevel);
            }
            return true;
        }
        return false;
    }

    public static void attemptLinkToDreamtwirlSpawn(ServerLevel level, BlockPos pos, BlockState state, SlumbersocketBlockEntity blockEntity, ItemStack heldItem) {
        Acherune acherune;
        if (!heldItem.has(MirthdewEncoreDataComponentTypes.LINKED_DREAMTWIRL)) {
            return;
        }
        LinkedDreamtwirlComponent linkedDreamtwirl = (LinkedDreamtwirlComponent)heldItem.get(MirthdewEncoreDataComponentTypes.LINKED_DREAMTWIRL);
        DreamtwirlStage stage = linkedDreamtwirl.getStage(level.getServer());
        if (stage == null) {
            return;
        }
        if (stage.isReady() && (acherune = stage.getEntranceAcherune(level.getRandom())) != null) {
            ItemStack newStack = heldItem.copy();
            newStack.remove(MirthdewEncoreDataComponentTypes.LINKED_DREAMTWIRL);
            newStack.set(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE, (Object)LinkedAcheruneComponent.fromAcheruneAndStage(stage, acherune));
            blockEntity.setHeldItem(newStack);
        }
    }

    public static void attemptEat(ServerLevel level, BlockPos socketPos, BlockState socketState, SlumbersocketBlockEntity blockEntity) {
        Optional blockPosOptional = BlockPos.findClosestMatch((BlockPos)socketPos, (int)8, (int)8, blockPos -> {
            BlockState checkState = level.getBlockState(blockPos);
            if (checkState.is(MirthdewEncoreBlocks.DREAMSEED)) {
                return (Boolean)checkState.getValue((Property)DreamseedBlock.LIT);
            }
            return false;
        });
        if (blockPosOptional.isEmpty()) {
            return;
        }
        BlockPos seedBlockPos = (BlockPos)blockPosOptional.get();
        SlumbersocketBlockEntity.eatSeed(level, socketPos, socketState, blockEntity, seedBlockPos);
    }

    public static void eatSeed(ServerLevel level, BlockPos socketPos, BlockState socketState, SlumbersocketBlockEntity blockEntity, BlockPos seedBlockPos) {
        Optional<DreamtwirlStage> stageOptional = SlumbersocketBlockEntity.createNewStage(level);
        if (stageOptional.isEmpty()) {
            return;
        }
        DreamtwirlStage stage = stageOptional.get();
        stage.generate(level.random.nextLong(), level);
        RandomSource random = level.getRandom();
        level.setBlockAndUpdate(seedBlockPos, Blocks.SOUL_FIRE.defaultBlockState());
        ItemStack itemStack = blockEntity.getHeldItem();
        ItemStack newStack = MirthdewEncoreItems.SLUMBERING_EYE.getDefaultInstance();
        newStack.applyComponentsAndValidate(itemStack.getComponentsPatch());
        newStack.set(MirthdewEncoreDataComponentTypes.LINKED_DREAMTWIRL, (Object)LinkedDreamtwirlComponent.fromStage(stage));
        newStack.set(DataComponents.DAMAGE, (Object)2);
        blockEntity.setHeldItem(newStack);
        blockEntity.markForUpdate(level);
        Vec3 socketPosV3 = socketPos.getCenter();
        level.playSound(null, socketPosV3.x, socketPosV3.y, socketPosV3.z, SoundEvents.ENDERMAN_SCREAM, SoundSource.BLOCKS, 0.3f, 0.3f);
        Vec3 seedOffset = seedBlockPos.getCenter().subtract(socketPosV3);
        ItemParticleOption seedParticle = new ItemParticleOption(ParticleTypes.ITEM, MirthdewEncoreItems.DREAMSEED.getDefaultInstance());
        int i = 0;
        while ((double)i < 4.0 + 10.0 * seedOffset.length()) {
            Vec3 particlePos = socketPosV3.add(seedOffset.scale((double)random.nextFloat()));
            level.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, particlePos.x, particlePos.y, particlePos.z, 6, 0.1, 0.1, 0.1, 0.05);
            level.sendParticles((ParticleOptions)ParticleTypes.WITCH, particlePos.x, particlePos.y, particlePos.z, 3, 0.1, 0.1, 0.1, 0.05);
            level.sendParticles((ParticleOptions)seedParticle, particlePos.x, particlePos.y, particlePos.z, 20, 0.1, 0.1, 0.1, 0.3);
            ++i;
        }
    }

    public static Optional<DreamtwirlStage> createNewStage(ServerLevel level) {
        DreamtwirlStageManager dreamtwirlStageManager = DreamtwirlStageManager.getMainDreamtwirlStageManager(level.getServer());
        if (dreamtwirlStageManager == null) {
            return Optional.empty();
        }
        return dreamtwirlStageManager.createNewStage();
    }
}

