/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.block.entity;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.block.entity.MirthdewEncoreBlockEntityTypes;
import phanastrae.mirthdew_encore.entity.DreamspeckEntity;
import phanastrae.mirthdew_encore.entity.MirthdewEncoreDamageTypes;
import phanastrae.mirthdew_encore.item.MirthdewEncoreItems;

public class VericDreamsnareBlockEntity
extends BlockEntity
implements GameEventListener.Provider<VibrationSystem.Listener>,
VibrationSystem {
    private static final Vec3 CENTER_POS = new Vec3(0.5, 0.5, 0.5);
    private static final Logger LOGGER = MirthdewEncore.LOGGER;
    private final VibrationSystem.User vibrationCallback = new VibrationCallback();
    private VibrationSystem.Data vibrationListenerData = new VibrationSystem.Data();
    private final VibrationSystem.Listener vibrationListener = new VibrationSystem.Listener((VibrationSystem)this);
    private Vec3 baseOffset = CENTER_POS;
    private Vec3 tongueBaseOffset = CENTER_POS;
    private Vec3 tongueTargetOffset = CENTER_POS;
    private Vec3 tongueOffset = CENTER_POS;
    private boolean tongueExtended = false;
    private boolean entitySnared = false;
    @Nullable
    private Entity snaredEntity = null;
    private final NonNullList<ItemStack> heldItem = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private double tongueDistance = 0.0;
    private double prevTongueDistance = 0.0;

    public VericDreamsnareBlockEntity(BlockPos pos, BlockState state) {
        super(MirthdewEncoreBlockEntityTypes.VERIC_DREAMSNARE, pos, state);
        this.updateCachedPositions(state);
    }

    public VibrationSystem.Data getVibrationData() {
        return this.vibrationListenerData;
    }

    public VibrationSystem.User getVibrationUser() {
        return this.vibrationCallback;
    }

    public VibrationSystem.Listener getListener() {
        return this.vibrationListener;
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ListTag nbtList;
        super.loadAdditional(nbt, registryLookup);
        RegistryOps registryOps = registryLookup.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (nbt.contains("listener", 10)) {
            VibrationSystem.Data.CODEC.parse((DynamicOps)registryOps, (Object)nbt.getCompound("listener")).resultOrPartial(string -> LOGGER.error("Failed to parse vibration listener for Sculk Shrieker: '{}'", string)).ifPresent(vibrationListener -> {
                this.vibrationListenerData = vibrationListener;
            });
        }
        if (nbt.contains("tongue_target_offset", 9) && (nbtList = nbt.getList("tongue_target_offset", 6)) != null && nbtList.size() == 3) {
            double x = nbtList.getDouble(0);
            double y = nbtList.getDouble(1);
            double z = nbtList.getDouble(2);
            this.tongueTargetOffset = new Vec3(x, y, z);
        }
        if (nbt.contains("tongue_extended", 1)) {
            this.tongueExtended = nbt.getBoolean("tongue_extended");
        }
        if (nbt.contains("entity_snared", 1)) {
            this.entitySnared = nbt.getBoolean("entity_snared");
        }
        if (nbt.contains("tongue_distance", 6)) {
            this.tongueDistance = nbt.getDouble("tongue_distance");
        }
        this.heldItem.clear();
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.heldItem, (HolderLookup.Provider)registryLookup);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        RegistryOps registryOps = registryLookup.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        VibrationSystem.Data.CODEC.encodeStart((DynamicOps)registryOps, (Object)this.vibrationListenerData).resultOrPartial(string -> LOGGER.error("Failed to encode vibration listener for Sculk Shrieker: '{}'", string)).ifPresent(nbtElement -> nbt.put("listener", nbtElement));
        nbt.put("tongue_target_offset", (Tag)this.toNbtList(this.tongueTargetOffset.x, this.tongueTargetOffset.y, this.tongueTargetOffset.z));
        nbt.putBoolean("tongue_extended", this.tongueExtended);
        nbt.putBoolean("entity_snared", this.entitySnared);
        nbt.putDouble("tongue_distance", this.tongueDistance);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.heldItem, (boolean)true, (HolderLookup.Provider)registryLookup);
    }

    protected ListTag toNbtList(double ... values) {
        ListTag nbtList = new ListTag();
        for (double d : values) {
            nbtList.add((Object)DoubleTag.valueOf((double)d));
        }
        return nbtList;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag nbtCompound = this.saveCustomOnly(registryLookup);
        nbtCompound.remove("listener");
        return nbtCompound;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setBlockState(BlockState state) {
        super.setBlockState(state);
        this.updateCachedPositions(state);
    }

    public void updateCachedPositions(BlockState state) {
        Direction facingDirection = state.hasProperty((Property)BlockStateProperties.FACING) ? (Direction)state.getValue((Property)BlockStateProperties.FACING) : Direction.UP;
        Vec3 directionVector = new Vec3(facingDirection.step());
        this.baseOffset = CENTER_POS.add(directionVector.scale(-0.5));
        this.tongueBaseOffset = this.baseOffset.add(directionVector.scale(0.1875));
    }

    public void setTongueTargetOffset(Vec3 value) {
        this.tongueTargetOffset = value;
        this.setChanged();
    }

    public void setTongueExtended(boolean value) {
        this.tongueExtended = value;
        this.setChanged();
    }

    public void setEntitySnared(boolean value) {
        this.entitySnared = value;
        this.setChanged();
    }

    public void setTongueDistance(double value) {
        this.tongueDistance = value;
        this.setChanged();
    }

    public Vec3 getBaseOffset() {
        return this.baseOffset;
    }

    public Vec3 getTongueBaseOffset() {
        return this.tongueBaseOffset;
    }

    public Vec3 getTongueTargetOffset() {
        return this.tongueTargetOffset;
    }

    public double getTongueLength(float tickDelta) {
        return this.prevTongueDistance + (double)tickDelta * (this.tongueDistance - this.prevTongueDistance);
    }

    public void setHeldItem(ItemStack itemStack) {
        this.heldItem.set(0, (Object)itemStack);
        this.setChanged();
    }

    public ItemStack getHeldItem() {
        return (ItemStack)this.heldItem.getFirst();
    }

    public boolean isHoldingItem() {
        return !this.getHeldItem().isEmpty();
    }

    public NonNullList<ItemStack> getItems() {
        return this.heldItem;
    }

    public Entity getSnaredEntity() {
        return this.snaredEntity;
    }

    public void sendUpdate() {
        if (this.level != null && !this.level.isClientSide && this.level.getBlockState(this.getBlockPos()) == this.getBlockState()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, VericDreamsnareBlockEntity snare) {
        snare.tick(level, pos, state);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            VibrationSystem.Ticker.tick((Level)level, (VibrationSystem.Data)this.getVibrationData(), (VibrationSystem.User)this.getVibrationUser());
        }
        if (this.tongueDistance <= 0.0 && !this.tongueExtended) {
            this.setTongueTargetOffset(this.tongueBaseOffset);
        }
        this.prevTongueDistance = this.tongueDistance;
        Vec3 offset = this.tongueTargetOffset.subtract(this.tongueBaseOffset);
        double offsetLength = offset.length();
        if (this.tongueExtended) {
            this.setTongueDistance(Math.min(this.tongueDistance + 0.05 + 0.25 * (offsetLength - this.tongueDistance), offsetLength));
        } else {
            this.setTongueDistance(Math.max(this.tongueDistance - (this.entitySnared ? 0.1 : 0.3), 0.0));
        }
        if (!level.isClientSide() && level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.tongueDistance != this.prevTongueDistance) {
                this.tongueOffset = this.tongueBaseOffset.add(offset.scale(this.tongueDistance / offsetLength));
            }
            if (this.tongueExtended) {
                Vec3 tonguePos = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).add(this.tongueOffset);
                Vec3 tMin = tonguePos.subtract(0.2, 0.2, 0.2);
                Vec3 tMax = tonguePos.add(0.2, 0.2, 0.2);
                AABB box = new AABB(tMin, tMax);
                for (Entity entity : level.getEntities(null, box)) {
                    DreamspeckEntity dreamspeckEntity;
                    if (entity instanceof DreamspeckEntity && !(dreamspeckEntity = (DreamspeckEntity)entity).isSnared()) {
                        dreamspeckEntity.setSnare(this.getBlockPos());
                        this.snaredEntity = entity;
                        this.setEntitySnared(true);
                        this.setTongueExtended(false);
                        this.sendUpdate();
                        continue;
                    }
                    if (entity instanceof ItemEntity) continue;
                    entity.hurt(MirthdewEncoreDamageTypes.of(level, MirthdewEncoreDamageTypes.DREAMSNARE_TONGUE), 2.0f);
                }
            }
            if (this.tongueDistance >= offsetLength) {
                this.setTongueExtended(false);
                this.sendUpdate();
            }
            if (this.entitySnared) {
                if (this.snaredEntity != null) {
                    this.snaredEntity.setPos(new Vec3((double)pos.getX(), (double)pos.getY() - (double)this.snaredEntity.getBbHeight() * 0.5, (double)pos.getZ()).add(this.tongueOffset));
                }
                if (this.tongueDistance <= 0.0) {
                    Entity entity = this.snaredEntity;
                    if (entity instanceof DreamspeckEntity) {
                        DreamspeckEntity dreamspeckEntity = (DreamspeckEntity)entity;
                        dreamspeckEntity.setSnare(null);
                    }
                    if (!this.isHoldingItem() && this.snaredEntity != null) {
                        this.eatEntity(serverWorld, this.snaredEntity);
                    }
                    this.snaredEntity = null;
                    this.setEntitySnared(false);
                    this.sendUpdate();
                }
            }
        }
    }

    public void eatEntity(ServerLevel level, Entity entity) {
        entity.discard();
        this.setHeldItem(MirthdewEncoreItems.DREAMSEED.getDefaultInstance());
        level.sendParticles((ParticleOptions)ParticleTypes.SCULK_CHARGE_POP, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, 100, 0.25, 0.25, 0.25, 0.02);
    }

    public void attack(ServerLevel level, @Nullable Entity entity) {
        if (entity == null) {
            return;
        }
        if (level.getDifficulty() == Difficulty.PEACEFUL && !(entity instanceof DreamspeckEntity)) {
            return;
        }
        BlockPos blockPos = this.getBlockPos();
        level.gameEvent((Holder)GameEvent.SHRIEK, blockPos, GameEvent.Context.of((Entity)entity));
        Vec3 target = entity.position().add(0.0, (double)entity.getBbHeight() * 0.5, 0.0);
        this.attack(level, target);
    }

    public void attack(ServerLevel level, Vec3 target) {
        BlockPos pos = this.getBlockPos();
        Vec3 tongueBasePos = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).add(this.tongueBaseOffset);
        BlockHitResult blockHitResult = level.clip(new ClipContext(tongueBasePos, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
        Vec3 offset = blockHitResult.getLocation().subtract(tongueBasePos);
        double offsetLength = offset.length();
        if (offsetLength > 9.0) {
            return;
        }
        BlockState state = this.getBlockState();
        Direction direction = state.hasProperty((Property)BlockStateProperties.FACING) ? (Direction)state.getValue((Property)BlockStateProperties.FACING) : Direction.UP;
        double dot = new Vec3(direction.step()).dot(offset.normalize());
        if (dot < 0.6) {
            return;
        }
        this.setTongueTargetOffset(offset.add(this.tongueBaseOffset));
        this.tongueOffset = this.tongueTargetOffset;
        this.setTongueExtended(true);
        this.sendUpdate();
        level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.SCULK_SENSOR_PLACE, SoundSource.HOSTILE, 4.0f, 1.4f);
    }

    public boolean canAttack(Entity entity) {
        if (this.tongueDistance > 0.0) {
            return false;
        }
        if (this.isHoldingItem()) {
            return false;
        }
        if (entity.isSpectator()) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().instabuild) {
                return false;
            }
        }
        return true;
    }

    class VibrationCallback
    implements VibrationSystem.User {
        private static final int RANGE = 8;
        private final PositionSource positionSource;

        public VibrationCallback() {
            this.positionSource = new BlockPositionSource(VericDreamsnareBlockEntity.this.worldPosition);
        }

        public int getListenerRadius() {
            return 8;
        }

        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.SHRIEKER_CAN_LISTEN;
        }

        public boolean canReceiveVibration(ServerLevel world, BlockPos pos, Holder<GameEvent> event, GameEvent.Context emitter) {
            Entity entity = emitter.sourceEntity();
            if (entity == null) {
                return false;
            }
            return VericDreamsnareBlockEntity.this.canAttack(entity);
        }

        public void onReceiveVibration(ServerLevel world, BlockPos pos, Holder<GameEvent> event, @Nullable Entity sourceEntity, @Nullable Entity entity, float distance) {
            VericDreamsnareBlockEntity.this.attack(world, sourceEntity);
        }

        public void onDataChanged() {
            VericDreamsnareBlockEntity.this.setChanged();
        }

        public boolean requiresAdjacentChunksToBeTicking() {
            return true;
        }
    }
}

