/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.card_spell;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.util.ExtraCodecs;
import phanastrae.mirthdew_encore.component.SpellEffectComponentTypes;
import phanastrae.mirthdew_encore.registry.MirthdewEncoreRegistries;

public record CardSpell(Component description, Definition definition, DataComponentMap effects) {
    public static final Codec<CardSpell> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("description").forGetter(CardSpell::description), (App)Definition.CODEC.forGetter(CardSpell::definition), (App)SpellEffectComponentTypes.COMPONENT_MAP_CODEC.optionalFieldOf("effects", (Object)DataComponentMap.EMPTY).forGetter(CardSpell::effects)).apply((Applicative)instance, CardSpell::new));
    public static final Codec<Holder<CardSpell>> ENTRY_CODEC = RegistryFixedCodec.create(MirthdewEncoreRegistries.CARD_SPELL_KEY);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<CardSpell>> ENTRY_PACKET_CODEC = ByteBufCodecs.holderRegistry(MirthdewEncoreRegistries.CARD_SPELL_KEY);

    public <T> List<T> getEffect(DataComponentType<List<T>> type) {
        return (List)this.effects.getOrDefault(type, List.of());
    }

    public record Definition(int mirthCost, int castDelayMs, int rechargeDelayMs, int inputCount) {
        public static final MapCodec<Definition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("mirth_cost", (Object)0).forGetter(Definition::mirthCost), (App)Codec.INT.optionalFieldOf("cast_delay_ms", (Object)0).forGetter(Definition::castDelayMs), (App)Codec.INT.optionalFieldOf("recharge_delay_ms", (Object)0).forGetter(Definition::rechargeDelayMs), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("input_count", (Object)0).forGetter(Definition::inputCount)).apply((Applicative)instance, Definition::new));
    }
}

