/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.card_spell;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import phanastrae.mirthdew_encore.card_spell.CardSpell;
import phanastrae.mirthdew_encore.card_spell.PlayerEntityMirthData;
import phanastrae.mirthdew_encore.component.SpellEffectComponentTypes;

public record SpellCast(Holder<CardSpell> cardSpellEntry, List<SpellCast> subCasts) {
    public static final Codec<SpellCast> CODEC = Codec.recursive((String)"MirthdewEncoreSpellCast", spellCastCodec -> RecordCodecBuilder.create(instance -> instance.group((App)CardSpell.ENTRY_CODEC.fieldOf("card_spell").forGetter(SpellCast::cardSpellEntry), (App)spellCastCodec.listOf().fieldOf("sub_casts").forGetter(SpellCast::subCasts)).apply((Applicative)instance, SpellCast::new)));
    public static final StreamCodec<RegistryFriendlyByteBuf, SpellCast> PACKET_CODEC = StreamCodec.recursive(spellCastPacketCodec -> StreamCodec.composite(CardSpell.ENTRY_PACKET_CODEC, SpellCast::cardSpellEntry, (StreamCodec)spellCastPacketCodec.apply(ByteBufCodecs.list()), SpellCast::subCasts, SpellCast::new));

    public SpellInfoCollector castSpell(ServerLevel world, Entity user) {
        SpellInfoCollector spellInfoCollector = new SpellInfoCollector();
        if (user instanceof Player) {
            Player player = (Player)user;
            spellInfoCollector.setMirth(PlayerEntityMirthData.fromPlayer(player).getMirth());
        }
        RandomSource random = user.getRandom();
        SoundEvent soundEvent = SoundEvents.BREEZE_SHOOT;
        world.playSound(null, user.blockPosition(), soundEvent, SoundSource.NEUTRAL, 0.4f, 0.7f + 1.2f * random.nextFloat());
        this.castSpellSingle(spellInfoCollector, world, user);
        if (user instanceof Player) {
            Player player = (Player)user;
            PlayerEntityMirthData.fromPlayer(player).setMirth(spellInfoCollector.getMirth());
        }
        return spellInfoCollector;
    }

    public void castSpellSingle(SpellInfoCollector spellInfoCollector, ServerLevel world, Entity user) {
        CardSpell cardSpell = (CardSpell)this.cardSpellEntry.value();
        spellInfoCollector.addCastDelay(cardSpell.definition().castDelayMs());
        spellInfoCollector.addRechargeDelay(cardSpell.definition().rechargeDelayMs());
        if (spellInfoCollector.tryConsumeMirth(cardSpell.definition().mirthCost())) {
            spellInfoCollector.markSuccess();
            cardSpell.getEffect(SpellEffectComponentTypes.CAST_NEXT).forEach(castNextEffect -> castNextEffect.castSpell(spellInfoCollector, world, user, this.subCasts));
            cardSpell.getEffect(SpellEffectComponentTypes.FIRE_ENTITY).forEach(fireEntityEffect -> fireEntityEffect.castSpell((Level)world, user));
            cardSpell.getEffect(SpellEffectComponentTypes.RUN_FUNCTION).forEach(runFunctionEffect -> runFunctionEffect.castSpell(world, user));
            cardSpell.getEffect(SpellEffectComponentTypes.EXPLODE).forEach(explodeEffect -> explodeEffect.apply(world, user));
        } else {
            spellInfoCollector.markFailure();
        }
    }

    public static class SpellInfoCollector {
        private long mirth;
        private int castDelayMs;
        private int rechargeDelayMs;
        private boolean hadSuccess = false;
        private boolean hadFailure = false;

        public void addCastDelay(int timeMs) {
            this.castDelayMs += timeMs;
        }

        public void addRechargeDelay(int timeMs) {
            this.rechargeDelayMs += timeMs;
        }

        public int getCastDelayMs() {
            return this.castDelayMs;
        }

        public int getRechargeDelayMs() {
            return this.rechargeDelayMs;
        }

        public void setMirth(long value) {
            this.mirth = value;
        }

        public long getMirth() {
            return this.mirth;
        }

        public boolean tryConsumeMirth(long value) {
            if (value <= this.mirth) {
                this.mirth -= value;
                return true;
            }
            return false;
        }

        public void markSuccess() {
            this.hadSuccess = true;
        }

        public void markFailure() {
            this.hadFailure = true;
        }

        public boolean getHadSuccess() {
            return this.hadSuccess;
        }

        public boolean getHadFailure() {
            return this.hadFailure;
        }
    }

    public static class Builder {
        private Holder<CardSpell> cardSpell;
        private final List<SpellCast> children;
        private final List<Builder> unbuiltChildren;

        public Builder(Holder<CardSpell> cardSpell) {
            this.cardSpell = cardSpell;
            this.children = new ArrayList<SpellCast>();
            this.unbuiltChildren = new ArrayList<Builder>();
        }

        public void addChild(Builder spellCast) {
            this.unbuiltChildren.add(spellCast);
        }

        public boolean hasFreeSlots() {
            int targetSlots = ((CardSpell)this.cardSpell.value()).definition().inputCount();
            int currentSlots = this.children.size() + this.unbuiltChildren.size();
            return currentSlots < targetSlots;
        }

        public SpellCast build() {
            ArrayList<SpellCast> casts = new ArrayList<SpellCast>(this.children);
            for (Builder builder : this.unbuiltChildren) {
                casts.add(builder.build());
            }
            return new SpellCast(this.cardSpell, casts);
        }
    }
}

