/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.card_spell;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import phanastrae.mirthdew_encore.card_spell.CardSpell;
import phanastrae.mirthdew_encore.card_spell.SpellCast;
import phanastrae.mirthdew_encore.component.MirthdewEncoreDataComponentTypes;
import phanastrae.mirthdew_encore.component.type.CardSpellComponent;
import phanastrae.mirthdew_encore.component.type.SpellDeckContentsComponent;

public class SpellCastHelper {
    public static List<Holder<CardSpell>> spellListFromStack(ItemStack itemStack) {
        SpellDeckContentsComponent deckContentsComponent;
        ArrayList<Holder<CardSpell>> spellList = new ArrayList<Holder<CardSpell>>();
        CardSpellComponent cardSpellComponent = (CardSpellComponent)itemStack.get(MirthdewEncoreDataComponentTypes.CARD_SPELL);
        if (cardSpellComponent != null) {
            spellList.add(cardSpellComponent.cardSpell());
        }
        if ((deckContentsComponent = (SpellDeckContentsComponent)itemStack.get(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS)) != null) {
            for (ItemStack stack : deckContentsComponent.iterate()) {
                CardSpellComponent cardSpellComponent2 = (CardSpellComponent)stack.get(MirthdewEncoreDataComponentTypes.CARD_SPELL);
                if (cardSpellComponent2 == null) continue;
                spellList.add(cardSpellComponent2.cardSpell());
            }
        }
        return spellList;
    }

    public static List<SpellCast> castListFromSpellList(List<Holder<CardSpell>> spellList) {
        ArrayList<SpellCast.Builder> builderList = new ArrayList<SpellCast.Builder>();
        Stack<SpellCast.Builder> buildStack = new Stack<SpellCast.Builder>();
        for (Holder<CardSpell> cardSpellEntry : spellList) {
            SpellCast.Builder builder = new SpellCast.Builder(cardSpellEntry);
            if (buildStack.empty()) {
                builderList.add(builder);
                buildStack.push(builder);
            } else {
                ((SpellCast.Builder)buildStack.peek()).addChild(builder);
                buildStack.push(builder);
            }
            while (!buildStack.empty() && !((SpellCast.Builder)buildStack.peek()).hasFreeSlots()) {
                buildStack.pop();
            }
        }
        ArrayList<SpellCast> spellCasts = new ArrayList<SpellCast>();
        for (SpellCast.Builder builder : builderList) {
            spellCasts.add(builder.build());
        }
        return spellCasts;
    }

    public static List<SpellCast> castListFromStack(ItemStack stack) {
        return SpellCastHelper.castListFromSpellList(SpellCastHelper.spellListFromStack(stack));
    }
}

