/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.card_spell.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record FireEntityEffect(HolderSet<EntityType<?>> entityTypes, float speed, float divergence, CompoundTag nbt) {
    public static final MapCodec<FireEntityEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENTITY_TYPE).fieldOf("entity").forGetter(FireEntityEffect::entityTypes), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(1.0f)).forGetter(FireEntityEffect::speed), (App)Codec.FLOAT.optionalFieldOf("divergence", (Object)Float.valueOf(1.0f)).forGetter(FireEntityEffect::divergence), (App)CompoundTag.CODEC.optionalFieldOf("nbt", (Object)new CompoundTag()).forGetter(FireEntityEffect::nbt)).apply((Applicative)instance, FireEntityEffect::new));

    public void castSpell(Level world, Entity user) {
        Entity entity;
        RandomSource random = user.getRandom();
        Optional OREET = this.entityTypes().getRandomElement(random);
        if (OREET.isPresent() && (entity = ((EntityType)((Holder)OREET.get()).value()).create(world)) != null) {
            entity.load(this.nbt);
            if (entity instanceof Projectile) {
                Projectile projectileEntity = (Projectile)entity;
                projectileEntity.setOwner(user);
            }
            entity.setPos(user.getEyePosition());
            Vec3 relativeVelocity = user.getViewVector(1.0f).add(random.triangle(0.0, 0.0172275 * (double)this.divergence), random.triangle(0.0, 0.0172275 * (double)this.divergence), random.triangle(0.0, 0.0172275 * (double)this.divergence)).scale((double)this.speed);
            entity.setDeltaMovement(user.getDeltaMovement().add(relativeVelocity));
            world.addFreshEntity(entity);
        }
    }
}

