/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.client.dreamtwirl;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import phanastrae.mirthdew_encore.dreamtwirl.stage.DreamtwirlDebug;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room.RoomDoor;
import phanastrae.mirthdew_encore.util.RegionPos;

public class DreamtwirlDebugRenderer {
    public static void tryRender(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double camX, double camY, double camZ) {
        Level level;
        LocalPlayer player;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.getDebugOverlay().showDebugScreen() && (player = minecraft.player) != null && (level = player.level()) != null) {
            RegionPos regionPos = RegionPos.fromEntity((Entity)player);
            Optional<DreamtwirlDebug.DebugInfo> debugInfoOptional = DreamtwirlDebug.getInstance().getDebugInfo(regionPos.id);
            if (debugInfoOptional.isPresent()) {
                DreamtwirlDebug.DebugInfo debugInfo = debugInfoOptional.get();
                DreamtwirlDebugRenderer.render(poseStack, bufferSource, camX, camY, camZ, (Player)player, debugInfo);
            }
        }
    }

    public static void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double camX, double camY, double camZ, Player player, DreamtwirlDebug.DebugInfo debugInfo) {
        Vec3 playerPos = player.position();
        for (DreamtwirlDebug.DebugNode node : debugInfo.getNodes()) {
            BlockPos pos = node.pos();
            Vec3 pv3 = pos.getCenter();
            double distSqr = pv3.distanceToSqr(playerPos);
            if (!(distSqr < 256.0)) continue;
            DebugRenderer.renderFloatingText((PoseStack)poseStack, (MultiBufferSource)bufferSource, (String)node.doorType().getSerializedName(), (int)pos.getX(), (int)pos.getY(), (int)pos.getZ(), (int)-1);
        }
        VertexConsumer lines = bufferSource.getBuffer(RenderType.lines());
        PoseStack.Pose pose = poseStack.last();
        for (DreamtwirlDebug.DebugEdge edge : debugInfo.getEdges()) {
            DreamtwirlDebug.DebugNode start = debugInfo.getNodeOfId(edge.startId());
            DreamtwirlDebug.DebugNode end = debugInfo.getNodeOfId(edge.endId());
            if (start == null || end == null) continue;
            Vec3 startPos = start.pos().getCenter();
            Vec3 endPos = end.pos().getCenter();
            Vec3 dif = endPos.subtract(startPos).normalize();
            DreamtwirlDebugRenderer.drawLineVertex(pose, lines, startPos, dif, camX, camY, camZ, start.doorType());
            DreamtwirlDebugRenderer.drawLineVertex(pose, lines, endPos, dif, camX, camY, camZ, end.doorType());
        }
    }

    public static void drawLineVertex(PoseStack.Pose pose, VertexConsumer lines, Vec3 pos, Vec3 normal, double camX, double camY, double camZ, RoomDoor.DoorType doorType) {
        float b;
        float g;
        float r;
        DreamtwirlDebugRenderer.drawLineVertex(pose, lines, pos, normal, camX, camY, camZ, r, g, b, switch (doorType) {
            case RoomDoor.DoorType.ENTRANCE_ONLY -> {
                r = 0.25f;
                g = 1.0f;
                b = 0.25f;
                yield 1.0f;
            }
            case RoomDoor.DoorType.EXIT_ONLY -> {
                r = 1.0f;
                g = 0.5f;
                b = 0.25f;
                yield 1.0f;
            }
            default -> {
                r = 0.25f;
                g = 1.0f;
                b = 1.0f;
                yield 1.0f;
            }
        });
    }

    public static void drawLineVertex(PoseStack.Pose pose, VertexConsumer lines, Vec3 pos, Vec3 normal, double camX, double camY, double camZ, float r, float g, float b, float a) {
        lines.addVertex(pose, (float)(pos.x - camX), (float)(pos.y - camY), (float)(pos.z - camZ)).setColor(r, g, b, a).setNormal(pose, (float)normal.x, (float)normal.y, (float)normal.z);
    }
}

