/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.client.fluid;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.fluid.MirthdewEncoreFluids;
import phanastrae.mirthdew_encore.mixin.client.CameraAccessor;
import phanastrae.mirthdew_encore.registry.MirthdewEncoreFluidTags;

public class MirthdewEncoreClientFluids {
    private static final List<XPlatGenericClientFluid> XPGCF_LIST = new ObjectArrayList();
    public static final XPlatGenericClientFluid VESPERBILE = new XPlatGenericClientFluid(MirthdewEncoreFluidTags.VESPERBILE, (Fluid)MirthdewEncoreFluids.VESPERBILE, (Fluid)MirthdewEncoreFluids.FLOWING_VESPERBILE).setTint(-1).setFogStart(-4.0f).setFogEnd(24.0f).setFogColorInt(163, 67, 38).setStillTexture(MirthdewEncore.id("block/vesperbile_still")).setFlowTexture(MirthdewEncore.id("block/vesperbile_flow")).setOverlayTexture(MirthdewEncore.id("block/vesperbile_overlay"));

    public static void init() {
        MirthdewEncoreClientFluids.addXPGCFsToLists(VESPERBILE);
    }

    public static void forEachXPGCF(Consumer<XPlatGenericClientFluid> consumer) {
        XPGCF_LIST.forEach(consumer);
    }

    private static void addXPGCFsToLists(XPlatGenericClientFluid ... xpgcfs) {
        XPGCF_LIST.addAll(Arrays.asList(xpgcfs));
    }

    @Nullable
    public static XPlatGenericClientFluid getXPGCF(Camera camera) {
        BlockGetter level = ((CameraAccessor)camera).getLevel();
        if (level == null) {
            return null;
        }
        BlockPos cameraBlockPos = camera.getBlockPosition();
        FluidState cameraFluidState = level.getFluidState(cameraBlockPos);
        if (cameraFluidState.isEmpty() || cameraFluidState.is(FluidTags.WATER) || cameraFluidState.is(FluidTags.LAVA)) {
            return null;
        }
        double fluidHeight = (float)cameraBlockPos.getY() + cameraFluidState.getHeight(level, cameraBlockPos);
        double camHeight = camera.getPosition().y();
        if (camHeight >= fluidHeight) {
            return null;
        }
        return MirthdewEncoreClientFluids.getXPGCF(cameraFluidState);
    }

    @Nullable
    public static XPlatGenericClientFluid getXPGCF(FluidState fluidState) {
        for (XPlatGenericClientFluid xpgcf : XPGCF_LIST) {
            if (!fluidState.is(xpgcf.getFluidTag())) continue;
            return xpgcf;
        }
        return null;
    }

    public static class XPlatGenericClientFluid {
        private final TagKey<Fluid> fluidTag;
        private final Fluid still;
        private final Fluid flow;
        private ResourceLocation stillTexture = ResourceLocation.withDefaultNamespace((String)"block/water_still");
        private ResourceLocation flowTexture = ResourceLocation.withDefaultNamespace((String)"block/water_flow");
        @Nullable
        private ResourceLocation overlayTexture = ResourceLocation.withDefaultNamespace((String)"block/water_overlay");
        @Nullable
        private ResourceLocation screenEffectTexture = ResourceLocation.withDefaultNamespace((String)"textures/misc/underwater.png");
        private int tint = -1;
        private float fogStart = 0.0f;
        private float fogEnd = Float.POSITIVE_INFINITY;
        private Vector3f fogColor = new Vector3f(1.0f, 1.0f, 1.0f);
        private float fovScaleFactor = 0.85714287f;

        public XPlatGenericClientFluid(TagKey<Fluid> fluidTag, Fluid still, Fluid flow) {
            this.fluidTag = fluidTag;
            this.still = still;
            this.flow = flow;
        }

        public TagKey<Fluid> getFluidTag() {
            return this.fluidTag;
        }

        public Fluid getStill() {
            return this.still;
        }

        public Fluid getFlow() {
            return this.flow;
        }

        public XPlatGenericClientFluid setStillTexture(ResourceLocation stillTexture) {
            this.stillTexture = stillTexture;
            return this;
        }

        public ResourceLocation getStillTexture() {
            return this.stillTexture;
        }

        public XPlatGenericClientFluid setFlowTexture(ResourceLocation flowTexture) {
            this.flowTexture = flowTexture;
            return this;
        }

        public ResourceLocation getFlowTexture() {
            return this.flowTexture;
        }

        public XPlatGenericClientFluid setOverlayTexture(@Nullable ResourceLocation overlayTexture) {
            this.overlayTexture = overlayTexture;
            return this;
        }

        @Nullable
        public ResourceLocation getOverlayTexture() {
            return this.overlayTexture;
        }

        public XPlatGenericClientFluid setScreenEffectTexture(@Nullable ResourceLocation screenEffectTexture) {
            this.screenEffectTexture = screenEffectTexture;
            return this;
        }

        @Nullable
        public ResourceLocation getScreenEffectTexture() {
            return this.screenEffectTexture;
        }

        public XPlatGenericClientFluid setTint(int tint) {
            this.tint = tint;
            return this;
        }

        public int getTint() {
            return this.tint;
        }

        public XPlatGenericClientFluid setFogStart(float fogStart) {
            this.fogStart = fogStart;
            return this;
        }

        public float getFogStart() {
            return this.fogStart;
        }

        public XPlatGenericClientFluid setFogEnd(float fogEnd) {
            this.fogEnd = fogEnd;
            return this;
        }

        public float getFogEnd() {
            return this.fogEnd;
        }

        public XPlatGenericClientFluid setFogColor(Vector3f fogColor) {
            this.fogColor = fogColor;
            return this;
        }

        public XPlatGenericClientFluid setFogColor(float r, float g, float b) {
            return this.setFogColor(new Vector3f(r, g, b));
        }

        public XPlatGenericClientFluid setFogColorInt(int r, int g, int b) {
            return this.setFogColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
        }

        public float getFovScaleFactor() {
            return this.fovScaleFactor;
        }

        public XPlatGenericClientFluid setFovScaleFactor(float fovScaleFactor) {
            this.fovScaleFactor = fovScaleFactor;
            return this;
        }

        public Vector3f getFogColor() {
            return this.fogColor;
        }

        public void setupFog(float farPlaneDistance) {
            RenderSystem.setShaderFogStart((float)this.fogStart);
            if (this.fogEnd > farPlaneDistance) {
                RenderSystem.setShaderFogEnd((float)farPlaneDistance);
                RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
            } else {
                RenderSystem.setShaderFogEnd((float)this.fogEnd);
                RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
            }
        }
    }
}

