/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class BaccheniteGlimmerParticle
extends TextureSheetParticle {
    BaccheniteGlimmerParticle(ClientLevel level, SpriteSet sprites, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y - 0.125, z, xSpeed, ySpeed, zSpeed);
        this.setSize(0.01f, 0.01f);
        this.pickSprite(sprites);
        this.quadSize = this.quadSize * (this.random.nextFloat() * 0.2f + 1.3f) * 1.3f;
        this.lifetime = (int)(48.0 / (Math.random() * 0.8 + 0.2));
        this.hasPhysics = false;
        this.friction = 1.0f;
        this.gravity = 0.0f;
        this.setParticleSpeed(xSpeed, ySpeed, zSpeed);
    }

    public int getLightColor(float partialTick) {
        float f = ((float)this.age + partialTick) / (float)this.lifetime;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        int i = super.getLightColor(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class BaccheniteGlimmerProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public BaccheniteGlimmerProvider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BaccheniteGlimmerParticle glimmerParticle = new BaccheniteGlimmerParticle(level, this.sprite, x, y, z, xSpeed, ySpeed, zSpeed);
            glimmerParticle.setColor(0.9f, 0.4f, 0.9f);
            return glimmerParticle;
        }
    }
}

