/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.client.render.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.block.entity.SlumbersocketBlockEntity;
import phanastrae.mirthdew_encore.client.render.entity.model.MirthdewEncoreEntityModelLayers;
import phanastrae.mirthdew_encore.item.MirthdewEncoreItems;

public class SlumbersocketBlockEntityRenderer
implements BlockEntityRenderer<SlumbersocketBlockEntity> {
    private static final ResourceLocation TEXTURE = MirthdewEncore.id("textures/entity/slumbersocket/eye.png");
    private static final ResourceLocation TEXTURE_SLEEPY = MirthdewEncore.id("textures/entity/slumbersocket/eye_sleepy.png");
    private static final ResourceLocation TEXTURE_SLUMBERING = MirthdewEncore.id("textures/entity/slumbersocket/eye_slumbering.png");
    private final ModelPart eye;

    public SlumbersocketBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.eye = context.bakeLayer(MirthdewEncoreEntityModelLayers.SLUMBERSOCKET_EYE);
    }

    public void render(SlumbersocketBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        ResourceLocation textureId = this.getTexture(entity);
        if (textureId == null) {
            return;
        }
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.entityCutout((ResourceLocation)textureId));
        matrices.pushPose();
        matrices.translate(0.5, 0.5, 0.5);
        float yaw = -Mth.rotLerp((float)tickDelta, (float)entity.prevYaw, (float)entity.yaw);
        float pitch = Mth.lerp((float)tickDelta, (float)entity.prevPitch, (float)entity.pitch);
        matrices.mulPose(Axis.YP.rotationDegrees(yaw));
        matrices.mulPose(Axis.XN.rotationDegrees(pitch));
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        this.eye.render(matrices, vertexConsumer, light, overlay);
        matrices.popPose();
    }

    @Nullable
    public ResourceLocation getTexture(SlumbersocketBlockEntity entity) {
        ItemStack heldItem = entity.getHeldItem();
        if (heldItem.isEmpty()) {
            return null;
        }
        if (heldItem.is(MirthdewEncoreItems.SLUMBERING_EYE)) {
            return TEXTURE_SLUMBERING;
        }
        if (heldItem.is(MirthdewEncoreItems.SLEEPY_EYE)) {
            return TEXTURE_SLEEPY;
        }
        if (heldItem.is(Items.ENDER_EYE)) {
            return TEXTURE;
        }
        return null;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition eye = modelPartData.addOrReplaceChild("eye", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)16);
    }
}

