/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.client.render.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.block.entity.VericDreamsnareBlockEntity;
import phanastrae.mirthdew_encore.client.render.entity.model.MirthdewEncoreEntityModelLayers;

public class VericDreamsnareBlockEntityRenderer
implements BlockEntityRenderer<VericDreamsnareBlockEntity> {
    private static final ResourceLocation TEXTURE = MirthdewEncore.id("textures/entity/veric_dreamsnare/tongue.png");
    private final ModelPart tongueBody;
    private final ModelPart tongueTip;
    private final ItemRenderer itemRenderer;

    public VericDreamsnareBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(MirthdewEncoreEntityModelLayers.DREAMSNARE_TONGUE);
        this.tongueBody = root.getChild("tongue_body");
        this.tongueTip = root.getChild("tongue_tip");
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(VericDreamsnareBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE));
        Level level = entity.getLevel();
        long time = level == null ? 0L : level.getGameTime();
        boolean holdingItem = entity.isHoldingItem();
        matrices.pushPose();
        Vec3 tongueBaseOffset = entity.getTongueBaseOffset();
        matrices.translate(tongueBaseOffset.x, tongueBaseOffset.y, tongueBaseOffset.z);
        Vec3 baseOffset = entity.getBaseOffset();
        Vec3 tongueTargetOffset = holdingItem ? tongueBaseOffset : entity.getTongueTargetOffset();
        Vec3 targetOffset = tongueTargetOffset.subtract(baseOffset);
        Vec3 offsetNormalised = targetOffset.normalize();
        double offset = 0.5 + 0.25 * (double)Math.sin((float)Math.toRadians((float)(((float)(time % 90L) + tickDelta) * 4.0f)));
        double tongueLength = holdingItem ? offset : entity.getTongueLength(tickDelta);
        float yaw = (float)Mth.atan2((double)offsetNormalised.x, (double)offsetNormalised.z);
        float pitch = (float)Mth.atan2((double)offsetNormalised.y, (double)offsetNormalised.horizontalDistance());
        matrices.mulPose(Axis.YP.rotation(yaw));
        matrices.mulPose(Axis.XN.rotation(pitch - 1.5707964f));
        float l = (float)tongueLength;
        float spinRotation = l * ((float)java.lang.Math.PI * 2) / 5.0f;
        matrices.mulPose(Axis.YP.rotation(spinRotation));
        matrices.pushPose();
        matrices.translate(0.0f, l - 1.0f, 0.0f);
        this.tongueTip.render(matrices, vertexConsumer, light, overlay);
        matrices.popPose();
        if (l > 0.0f) {
            matrices.pushPose();
            matrices.scale(1.0f, l, 1.0f);
            this.tongueBody.render(matrices, vertexConsumer, light, overlay);
            matrices.popPose();
        }
        if (holdingItem) {
            ItemStack itemStack = entity.getHeldItem();
            if (level != null) {
                matrices.pushPose();
                matrices.mulPose(Axis.YP.rotationDegrees(((float)(time % 120L) + tickDelta) * 3.0f));
                matrices.translate(0.0, offset + 0.4, 0.0);
                matrices.scale(2.0f, 2.0f, 2.0f);
                matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
                this.itemRenderer.renderStatic(null, itemStack, ItemDisplayContext.FIXED, false, matrices, vertexConsumers, level, light, overlay, 0);
                matrices.popPose();
            }
        }
        matrices.popPose();
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition tongue_body = modelPartData.addOrReplaceChild("tongue_body", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -18.0f, -0.5f, 2.0f, 16.0f, 2.0f), PartPose.offset((float)0.0f, (float)18.0f, (float)-0.5f));
        PartDefinition tongue_tip = modelPartData.addOrReplaceChild("tongue_tip", CubeListBuilder.create().texOffs(18, 8).addBox(-1.5f, -5.5f, -1.0f, 3.0f, 5.0f, 3.0f).texOffs(8, 0).addBox(0.0f, -1.0f, -2.0f, 0.0f, 4.0f, 5.0f), PartPose.offset((float)0.0f, (float)18.0f, (float)-0.5f));
        PartDefinition rotated_block = tongue_tip.addOrReplaceChild("rotated_block", CubeListBuilder.create().texOffs(18, 0).addBox(-1.5f, -2.5f, -1.5f, 3.0f, 5.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.5f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition rotated_flat = tongue_tip.addOrReplaceChild("rotated_flat", CubeListBuilder.create().texOffs(8, 0).addBox(0.0f, -1.0f, -2.0f, 0.0f, 4.0f, 5.0f), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.5f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32);
    }
}

